/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlockEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelayBlock
extends Block
implements IBE<RedstoneRelayBlockEntity>,
IWrenchable,
TransformableBlock {
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShape HORIZONTAL_SHAPE_MAIN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape HORIZONTAL_SHAPE_X = Shapes.or((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)6.0, (double)5.0, (double)7.0, (double)10.0), Block.box((double)11.0, (double)0.0, (double)6.0, (double)15.0, (double)7.0, (double)10.0)});
    public static final VoxelShape HORIZONTAL_SHAPE_Z = Shapes.or((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)7.0, (double)5.0), Block.box((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)7.0, (double)15.0)});
    public static final VoxelShaper VERTICAL_SHAPE = CAShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).add(1.0, 0.0, 6.0, 5.0, 7.0, 10.0).add(11.0, 0.0, 6.0, 15.0, 7.0, 10.0).forDirectional();
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);

    public RedstoneRelayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            return VERTICAL_SHAPE.get(dir.getOpposite());
        }
        Direction.Axis axis = dir.getAxis();
        return axis == Direction.Axis.X ? HORIZONTAL_SHAPE_X : HORIZONTAL_SHAPE_Z;
    }

    public Class<RedstoneRelayBlockEntity> getBlockEntityClass() {
        return RedstoneRelayBlockEntity.class;
    }

    public BlockEntityType<? extends RedstoneRelayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.REDSTONE_RELAY.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VERTICAL, HORIZONTAL_FACING, POWERED, NodeRotation.ROTATION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        if (c.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)(c.getPlayer().isShiftKeyDown() ? c.getHorizontalDirection().getCounterClockWise() : c.getHorizontalDirection().getClockWise()))).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)c.getClickedFace().getOpposite())).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(true));
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        boolean flag = (Boolean)state.getValue((Property)POWERED);
        boolean flag1 = this.shouldBePowered((Level)worldIn, pos, state);
        if (flag && !flag1) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.FALSE), 2);
        } else if (!flag) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.canSurvive((LevelReader)worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            BlockEntity tileentity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
            RedstoneRelayBlock.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
            worldIn.removeBlock(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        return RedstoneRelayBlock.canSupportCenter((LevelReader)world, (BlockPos)(vertical ? pos.relative(direction) : pos.below()), (Direction)(vertical ? direction.getOpposite() : Direction.UP));
    }

    protected void updateState(Level worldIn, BlockPos pos, BlockState state) {
        boolean flag1;
        boolean flag = (Boolean)state.getValue((Property)POWERED);
        if (flag != (flag1 = this.shouldBePowered(worldIn, pos, state)) && !worldIn.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.VERY_HIGH;
            worldIn.scheduleTick(pos, (Block)this, this.getDelay(state), tickpriority);
        }
    }

    private int getDelay(BlockState state) {
        return 2;
    }

    protected boolean shouldBePowered(Level worldIn, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(worldIn, pos, state) > 0;
    }

    protected int calculateInputStrength(Level worldIn, BlockPos pos, BlockState state) {
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        if (vertical) {
            BlockPos blockpos1 = pos.relative(Direction.UP);
            BlockPos blockpos2 = pos.relative(Direction.DOWN);
            int i = Math.max(worldIn.getSignal(blockpos1, Direction.DOWN), worldIn.getSignal(blockpos2, Direction.UP));
            BlockState blockstate1 = worldIn.getBlockState(blockpos1);
            BlockState blockstate2 = worldIn.getBlockState(blockpos2);
            return Math.max(i, Math.max(blockstate1.is(Blocks.REDSTONE_WIRE) ? (Integer)blockstate1.getValue((Property)RedStoneWireBlock.POWER) : 0, blockstate2.is(Blocks.REDSTONE_WIRE) ? (Integer)blockstate2.getValue((Property)RedStoneWireBlock.POWER) : 0));
        }
        Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        BlockPos blockpos1 = pos.relative(direction.getClockWise());
        BlockPos blockpos2 = pos.relative(direction.getCounterClockWise());
        int i = Math.max(worldIn.getSignal(blockpos1, direction.getClockWise()), worldIn.getSignal(blockpos2, direction.getCounterClockWise()));
        int j = Math.max(worldIn.getDirectSignal(blockpos1, direction.getClockWise()), worldIn.getDirectSignal(blockpos2, direction.getCounterClockWise()));
        BlockState blockstate1 = worldIn.getBlockState(blockpos1);
        BlockState blockstate2 = worldIn.getBlockState(blockpos2);
        return Math.max(Math.max(i, j), Math.max(blockstate1.is(Blocks.REDSTONE_WIRE) ? (Integer)blockstate1.getValue((Property)RedStoneWireBlock.POWER) : 0, blockstate2.is(Blocks.REDSTONE_WIRE) ? (Integer)blockstate2.getValue((Property)RedStoneWireBlock.POWER) : 0));
    }

    protected int getPowerOnSides(LevelReader worldIn, BlockPos pos, Direction direction) {
        Direction direction1 = direction.getClockWise();
        Direction direction2 = direction.getCounterClockWise();
        return Math.max(this.getPowerOnSide(worldIn, pos.relative(direction1), direction2), this.getPowerOnSide(worldIn, pos.relative(direction2), direction1));
    }

    protected int getPowerOnSide(LevelReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.getBlockState(pos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.is(Blocks.REDSTONE_BLOCK)) {
                return 15;
            }
            return blockstate.is(Blocks.REDSTONE_WIRE) ? ((Integer)blockstate.getValue((Property)RedStoneWireBlock.POWER)).intValue() : worldIn.getDirectSignal(pos, side);
        }
        return 0;
    }

    protected boolean isAlternateInput(BlockState state) {
        return state.isSignalSource();
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.scheduleTick(pos, (Block)this, 1);
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(worldIn, pos, state, player);
        if (worldIn.isClientSide()) {
            return state;
        }
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te == null) {
            return state;
        }
        if (!(te instanceof IWireNode)) {
            return state;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn, !player.isCreative());
        return state;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext c) {
        BlockEntity te = c.getLevel().getBlockEntity(c.getClickedPos());
        if (te == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(te instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cte = (IWireNode)te;
        if (!c.getLevel().isClientSide()) {
            cte.dropWires(c.getLevel(), c.getPlayer(), !c.getPlayer().isCreative());
        }
        return super.onSneakWrenched(state, c);
    }

    public boolean canConnectRedstone(@Nullable BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, @Nullable Direction side) {
        if (pos == null || side == null || state == null || world == null) {
            return false;
        }
        return (Boolean)state.getValue((Property)VERTICAL) == false && side.getAxis() != ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxis();
    }

    private BlockState fromRotation(BlockState state, Direction dir) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)dir);
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return this.fromRotation(state, direction.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.rotate(state, direction);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.fromRotation(state, mirror.mirror((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        NodeRotation rotation = NodeRotation.get(transform.rotationAxis, transform.rotation);
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            state = this.rotate(state, transform.rotation);
        }
        return (BlockState)state.setValue(NodeRotation.ROTATION, (Comparable)((Object)rotation));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CABlockEntities.REDSTONE_RELAY.create(pos, state);
    }
}

