/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.barbed_wire;

import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.index.CADamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;

public class BarbedWireBlock
extends Block
implements IShearable {
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BarbedWireBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        double delta = Math.abs(entity.getX() - entity.xOld) + Math.abs(entity.getY() - entity.yOld) + Math.abs(entity.getZ() - entity.zOld);
        if (entity instanceof LivingEntity && delta > 0.0 && entity.hurt(CADamageTypes.barbedWire(level), ((Double)CommonConfig.BARBED_WIRE_DAMAGE.get()).floatValue())) {
            entity.playSound(SoundEvents.PLAYER_HURT_SWEET_BERRY_BUSH, 1.0f, 1.0f);
        }
        entity.makeStuckInBlock(state, new Vec3(0.25, (double)0.05f, 0.25));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VERTICAL, HORIZONTAL_FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        if (c.getPlayer() == null) {
            return this.defaultBlockState();
        }
        if (c.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)(c.getPlayer().isShiftKeyDown() ? c.getHorizontalDirection().getClockWise() : c.getHorizontalDirection()))).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)c.getClickedFace().getOpposite())).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(true));
    }
}

