/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition;

import com.mojang.brigadier.CommandDispatcher;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.commands.CCApiCommand;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.index.CAArmInteractions;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CACapabilities;
import com.mrh0.createaddition.index.CADamageTypes;
import com.mrh0.createaddition.index.CADisplaySources;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.index.CAFluids;
import com.mrh0.createaddition.index.CAItemProperties;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.index.CAPartials;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.index.CASounds;
import com.mrh0.createaddition.network.ClientPayloadHandler;
import com.mrh0.createaddition.network.EnergyNetworkPacketPayload;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.network.ServerPayloadHandler;
import com.mrh0.createaddition.network.TimeRemainingPacketPayload;
import com.mrh0.createaddition.ponder.CAPonderPlugin;
import com.mrh0.createaddition.trains.schedule.CASchedule;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="createaddition")
public class CreateAddition {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "createaddition";
    public static boolean IE_ACTIVE = false;
    public static boolean CC_ACTIVE = false;
    public static boolean AE2_ACTIVE = false;
    public static final CreateRegistrate REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)"createaddition").defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    private static final ItemLike[] excludedItemsList;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN_TAB;
    private static final String PROTOCOL = "1";

    public CreateAddition(IEventBus eventBus, ModContainer container) {
        eventBus.addListener(this::setup);
        eventBus.addListener(this::doClientStuff);
        eventBus.addListener(this::postInit);
        eventBus.addListener(this::onRegister);
        eventBus.addListener(RegisterCapabilitiesEvent.class, CACapabilities::register);
        eventBus.addListener(RegisterPayloadHandlersEvent.class, CreateAddition::registerPackets);
        NeoForge.EVENT_BUS.register((Object)this);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        IE_ACTIVE = ModList.get().isLoaded("immersiveengineering");
        CC_ACTIVE = ModList.get().isLoaded("computercraft");
        AE2_ACTIVE = ModList.get().isLoaded("ae2");
        REGISTRATE.registerEventListeners(eventBus);
        CABlocks.register();
        CABlockEntities.register();
        CAItems.register();
        CREATIVE_MODE_TABS.register(eventBus);
        CAFluids.register();
        CAEffects.register(eventBus);
        CARecipes.register(eventBus);
        CASounds.register(eventBus);
        CASchedule.register();
        CADamageTypes.register();
        CADisplaySources.register();
        CatnipServices.PLATFORM.executeOnClientOnly(() -> CAPartials::init);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(CAItemProperties::register);
        PonderIndex.addPlugin((PonderPlugin)new CAPonderPlugin());
        RenderType cutout = RenderType.cutoutMipped();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CABlocks.TESLA_COIL.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CABlocks.BARBED_WIRE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CABlocks.SMALL_LIGHT_CONNECTOR.get()), (RenderType)cutout);
    }

    public void postInit(FMLLoadCompleteEvent evt) {
        BoilerHeater.REGISTRY.register((Object)((Block)CABlocks.LIQUID_BLAZE_BURNER.get()), (level, pos, state) -> {
            BlazeBurnerBlock.HeatLevel value = (BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL);
            if (value == BlazeBurnerBlock.HeatLevel.NONE) {
                return -1.0f;
            }
            if (value == BlazeBurnerBlock.HeatLevel.SEETHING) {
                return 2.0f;
            }
            if (value.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return 1.0f;
            }
            return 0.0f;
        });
        LOGGER.info("Create Crafts & Additions Initialized!");
    }

    public void onRegister(RegisterEvent event) {
        CAArmInteractions.register();
    }

    @SubscribeEvent
    public void onRegisterCommandEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispather = event.getDispatcher();
        CCApiCommand.register((CommandDispatcher<CommandSourceStack>)dispather);
    }

    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL);
        registrar = registrar.executesOn(HandlerThread.MAIN);
        registrar.playBidirectional(ObservePacketPayload.TYPE, ObservePacketPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleObservePayload, ServerPayloadHandler::handleObservePayload));
        registrar.playBidirectional(EnergyNetworkPacketPayload.TYPE, EnergyNetworkPacketPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleEnergyNetworkPayload, ServerPayloadHandler::handleEnergyNetworkPayload));
        registrar.playBidirectional(TimeRemainingPacketPayload.TYPE, TimeRemainingPacketPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleTimeRemainingPayload, ServerPayloadHandler::handleTimeRemainingPayload));
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        excludedItemsList = new ItemLike[]{CAItems.CAKE_BASE, CAItems.CAKE_BASE_BAKED, CAItems.BIOMASS};
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MODID);
        MAIN_TAB = CREATIVE_MODE_TABS.register(MODID, () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> ((ElectricMotorBlock)((Object)((Object)((Object)CABlocks.ELECTRIC_MOTOR.get())))).asItem().getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.createaddition.main")).displayItems((itemDisplayParameters, output) -> REGISTRATE.getAll(Registries.ITEM).forEach(item -> {
            for (ItemLike excluded : excludedItemsList) {
                if (!item.is((Object)excluded.asItem())) continue;
                return;
            }
            output.accept((ItemLike)item.get());
        })).build());
    }
}

