/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CuttingRecipeGen
extends ProcessingRecipeGen {
    CreateRecipeProvider.GeneratedRecipe ANDESITE_ALLOY = this.create(CreateRecipeProvider.I::andesiteAlloy, b -> b.duration(200).output((ItemLike)AllBlocks.SHAFT.get(), 6));
    CreateRecipeProvider.GeneratedRecipe BAMBOO_PLANKS = this.create(() -> Blocks.BAMBOO_PLANKS, b -> b.duration(20).output((ItemLike)Blocks.BAMBOO_MOSAIC, 1));
    CreateRecipeProvider.GeneratedRecipe ARS_N = this.cuttingCompat(Mods.ARS_N, "purple_archwood", "green_archwood", "red_archwood");
    CreateRecipeProvider.GeneratedRecipe ARS_E_1 = this.stripAndMakePlanksDiffPlanksModId(Mods.ARS_E, null, "stripped_yellow_archwood_log", Mods.ARS_N, "archwood_planks");
    CreateRecipeProvider.GeneratedRecipe ARS_E_2 = this.stripAndMakePlanksDiffPlanksModId(Mods.ARS_E, null, "stripped_yellow_archwood", Mods.ARS_N, "archwood_planks");
    CreateRecipeProvider.GeneratedRecipe RU_1 = this.stripAndMakePlanks(Mods.RU, "brimwood_log_magma", "stripped_brimwood_log", null);
    CreateRecipeProvider.GeneratedRecipe RU_2 = this.stripAndMakePlanks(Mods.RU, "ashen_log", "stripped_dead_log", null);
    CreateRecipeProvider.GeneratedRecipe RU_3 = this.stripAndMakePlanks(Mods.RU, "ashen_wood", "stripped_dead_wood", null);
    CreateRecipeProvider.GeneratedRecipe RU_4 = this.stripOnlyDiffModId(Mods.RU, "silver_birch_log", Mods.MC, "stripped_birch_log");
    CreateRecipeProvider.GeneratedRecipe RU_5 = this.stripOnlyDiffModId(Mods.RU, "silver_birch_wood", Mods.MC, "stripped_birch_wood");
    CreateRecipeProvider.GeneratedRecipe AUTUM_1 = this.stripAndMakePlanks(Mods.AUTUM, null, "sappy_maple_log", "maple_planks");
    CreateRecipeProvider.GeneratedRecipe AUTUM_2 = this.stripAndMakePlanks(Mods.AUTUM, null, "sappy_maple_wood", "maple_planks");
    CreateRecipeProvider.GeneratedRecipe ENDERGETIC_1 = this.stripAndMakePlanks(Mods.ENDER, "glowing_poise_stem", "stripped_poise_stem", null);
    CreateRecipeProvider.GeneratedRecipe ENDERGETIC_2 = this.stripAndMakePlanks(Mods.ENDER, "glowing_poise_wood", "stripped_poise_wood", null);
    CreateRecipeProvider.GeneratedRecipe IE_WIRES = this.ieWires("copper", "electrum", "aluminum", "steel", "lead");

    CreateRecipeProvider.GeneratedRecipe stripAndMakePlanks(Block wood, Block stripped, Block planks) {
        return this.stripAndMakePlanks(wood, stripped, planks, 6);
    }

    CreateRecipeProvider.GeneratedRecipe stripAndMakePlanks(Block wood, Block stripped, Block planks, int planksAmount) {
        this.create(() -> wood, b -> b.duration(50).output((ItemLike)stripped));
        return this.create(() -> stripped, b -> b.duration(50).output((ItemLike)planks, planksAmount));
    }

    CreateRecipeProvider.GeneratedRecipe cuttingCompat(Mods mod, String ... woodtypes) {
        for (String type : woodtypes) {
            Object planks = type + "_planks";
            if (mod == Mods.ARS_N && type.contains("archwood")) {
                planks = "archwood_planks";
            }
            String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
            String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
            this.stripAndMakePlanks(mod, type + "_log", strippedPre + type + "_log" + strippedPost, (String)planks);
            String wood = type + (mod.omitWoodSuffix ? "" : "_wood");
            this.stripAndMakePlanks(mod, wood, strippedPre + wood + strippedPost, (String)planks);
        }
        return null;
    }

    CreateRecipeProvider.GeneratedRecipe cuttingCompatLogOnly(Mods mod, String ... woodtypes) {
        for (String type : woodtypes) {
            String planks = type + "_planks";
            String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
            String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
            this.stripAndMakePlanks(mod, type + "_log", strippedPre + type + "_log" + strippedPost, planks);
        }
        return null;
    }

    CreateRecipeProvider.GeneratedRecipe stripOnlyDiffModId(Mods mod1, String wood, Mods mod2, String stripped) {
        this.create("compat/" + mod1.getId() + "/" + wood, b -> b.duration(50).require(mod1, wood).output(1.0f, mod2, stripped, 1).whenModLoaded(mod1.getId()));
        return null;
    }

    CreateRecipeProvider.GeneratedRecipe stripAndMakePlanksDiffPlanksModId(Mods mod1, String log, String stripped, Mods mod2, String planks) {
        if (log != null) {
            this.create("compat/" + mod1.getId() + "/" + log, b -> b.duration(50).require(mod1, log).output(1.0f, mod1, stripped, 1).whenModLoaded(mod1.getId()));
        }
        if (planks != null) {
            this.create("compat/" + mod1.getId() + "/" + stripped, b -> b.duration(50).require(mod1, stripped).output(1.0f, mod2, planks, 6).whenModLoaded(mod1.getId()));
        }
        return null;
    }

    CreateRecipeProvider.GeneratedRecipe stripAndMakePlanks(Mods mod, String wood, String stripped, String planks) {
        if (wood != null) {
            this.create("compat/" + mod.getId() + "/" + wood, b -> b.duration(50).require(mod, wood).output(1.0f, mod, stripped, 1).whenModLoaded(mod.getId()));
        }
        if (planks != null) {
            if (!Objects.equals(mod.getId(), Mods.VH.getId())) {
                this.create("compat/" + mod.getId() + "/" + stripped, b -> b.duration(50).require(mod, stripped).output(1.0f, mod, planks, 6).whenModLoaded(mod.getId()));
            } else {
                this.create("compat/" + mod.getId() + "/" + stripped, b -> b.duration(50).require(mod, stripped).output(1.0f, mod, planks, 4).whenModLoaded(mod.getId()));
            }
        }
        return null;
    }

    public CuttingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    CreateRecipeProvider.GeneratedRecipe ieWires(String ... metals) {
        for (String metal : metals) {
            this.create(Mods.IE.recipeId("wire_" + metal), b -> b.duration(50).require(AllTags.commonItemTag("plates/" + metal)).output(1.0f, Mods.IE, "wire_" + metal, 2).whenModLoaded(Mods.IE.getId()));
        }
        return null;
    }

    @Override
    protected AllRecipeTypes getRecipeType() {
        return AllRecipeTypes.CUTTING;
    }
}

