/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockItem;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.lang.Lang;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class ClipboardOverrides {
    public static void switchTo(ClipboardType type, ItemStack clipboardItem) {
        clipboardItem.set(AllDataComponents.CLIPBOARD_TYPE, (Object)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModelOverridesClient(ClipboardBlockItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)ClipboardType.ID, (pStack, pLevel, pEntity, pSeed) -> ((ClipboardType)((Object)((Object)pStack.getOrDefault(AllDataComponents.CLIPBOARD_TYPE, (Object)ClipboardType.EMPTY)))).ordinal());
    }

    public static ItemModelBuilder addOverrideModels(DataGenContext<Item, ClipboardBlockItem> c, RegistrateItemModelProvider p) {
        ItemModelBuilder builder = p.generated(() -> c.get());
        for (ClipboardType type : ClipboardType.values()) {
            int i = type.ordinal();
            builder.override().predicate(ClipboardType.ID, (float)i).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_" + i)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", Create.asResource("item/" + type.file))).end();
        }
        return builder;
    }

    public static enum ClipboardType implements StringRepresentable
    {
        EMPTY("empty_clipboard"),
        WRITTEN("clipboard"),
        EDITING("clipboard_and_quill");

        public static final Codec<ClipboardType> CODEC;
        public static final StreamCodec<ByteBuf, ClipboardType> STREAM_CODEC;
        public String file;
        public static ResourceLocation ID;

        private ClipboardType(String file) {
            this.file = file;
        }

        @NotNull
        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }

        static {
            CODEC = StringRepresentable.fromValues(ClipboardType::values);
            STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(ClipboardType.class);
            ID = Create.asResource("clipboard_type");
        }
    }
}

