/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.MappingResolverImpl;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.patch.LVTOffsets;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.api.RefmapHolder;
import org.sinytra.adapter.patch.transformer.serialization.PatchSerialization;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.sinytra.adapter.patch.util.provider.MixinClassLookup;
import org.sinytra.adapter.patch.util.provider.ZipClassLookup;
import org.sinytra.connector.locator.EmbeddedDependencies;
import org.sinytra.connector.service.FabricMixinBootstrap;
import org.sinytra.connector.transformer.AccessWidenerTransformer;
import org.sinytra.connector.transformer.AccessorRedirectTransformer;
import org.sinytra.connector.transformer.FieldToMethodTransformer;
import org.sinytra.connector.transformer.JarSignatureStripper;
import org.sinytra.connector.transformer.MappingAwareReferenceMapper;
import org.sinytra.connector.transformer.MixinPatchTransformer;
import org.sinytra.connector.transformer.OptimizedRenamingTransformer;
import org.sinytra.connector.transformer.RefmapRemapper;
import org.sinytra.connector.transformer.jar.BytecodeFixerUpperFrontend;
import org.sinytra.connector.transformer.jar.IntermediateMapping;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.sinytra.connector.transformer.jar.SimpleClassLookup;
import org.sinytra.connector.transformer.patch.ClassAnalysingTransformer;
import org.sinytra.connector.transformer.patch.ClassNodeTransformer;
import org.sinytra.connector.transformer.patch.ConnectorRefmapHolder;
import org.sinytra.connector.transformer.patch.ReflectionRenamingTransformer;
import org.sinytra.connector.util.ConnectorUtil;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.ClassProvider;
import reloc.net.minecraftforge.fart.api.Renamer;
import reloc.net.minecraftforge.fart.internal.EnhancedRemapper;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class JarTransformInstance {
    private static final String FABRIC_MAPPING_NAMESPACE = "Fabric-Mapping-Namespace";
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MappingAwareReferenceMapper remapper;
    private final List<? extends Patch> adapterPatches;
    private final LVTOffsets lvtOffsetsData;
    private final BytecodeFixerUpperFrontend bfu;
    private final EnhancedRemapper enhancedRemapper;
    private final ClassLookup cleanClassLookup;
    private final List<Path> libs;
    private final PatchAuditTrail auditTrail;

    public JarTransformInstance(ClassProvider classProvider, Collection<IModFile> loadedMods, List<Path> libs) {
        MappingResolverImpl resolver = FabricLoaderImpl.INSTANCE.getMappingResolver();
        resolver.getMap("mojang", "intermediary");
        resolver.getMap("intermediary", "mojang");
        this.remapper = new MappingAwareReferenceMapper(resolver.getCurrentMap("intermediary"));
        Path patchDataPath = EmbeddedDependencies.getAdapterData("patch_data.json");
        try (BufferedReader reader = Files.newBufferedReader(patchDataPath);){
            JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            this.adapterPatches = PatchSerialization.deserialize(json, JsonOps.INSTANCE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Path offsetDataPath = EmbeddedDependencies.getAdapterData("lvt_offsets.json");
        try (BufferedReader reader = Files.newBufferedReader(offsetDataPath);){
            JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            this.lvtOffsetsData = LVTOffsets.fromJson(json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        IMappingFile mappingFile = FabricLoaderImpl.INSTANCE.getMappingResolver().getCurrentMap("intermediary");
        OptimizedRenamingTransformer.IntermediaryClassProvider intermediaryClassProvider = new OptimizedRenamingTransformer.IntermediaryClassProvider(classProvider, mappingFile, mappingFile.reverse(), s -> {});
        this.enhancedRemapper = new OptimizedRenamingTransformer.MixinAwareEnhancedRemapper(intermediaryClassProvider, mappingFile, IntermediateMapping.get("intermediary"), s -> {});
        this.cleanClassLookup = JarTransformInstance.createCleanClassLookup();
        this.bfu = new BytecodeFixerUpperFrontend(this.cleanClassLookup, MixinClassLookup.INSTANCE);
        this.libs = libs;
        this.auditTrail = PatchAuditTrail.create();
        MixinPatchTransformer.completeSetup(loadedMods);
    }

    public BytecodeFixerUpperFrontend getBfu() {
        return this.bfu;
    }

    @Nullable
    public PatchAuditTrail transformJar(File input, Path output, JarTransformer.FabricModFileMetadata metadata) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (metadata.generated()) {
            JarTransformInstance.processGeneratedJar(input, output, stopwatch);
            return null;
        }
        String jarMapping = metadata.manifestAttributes().getValue(FABRIC_MAPPING_NAMESPACE);
        if (jarMapping != null && !jarMapping.equals("intermediary")) {
            LOGGER.error("Found transformable jar with unsupported mapping {}, currently only {} is supported", (Object)jarMapping, (Object)"intermediary");
        }
        MappingResolverImpl resolver = FabricLoaderImpl.INSTANCE.getMappingResolver();
        RefmapRemapper.RefmapFiles refmap = RefmapRemapper.processRefmaps(input.toPath(), metadata.refmaps(), this.remapper, this.libs);
        IMappingFile srgToIntermediary = resolver.getMap("mojang", "intermediary");
        IMappingFile intermediaryToSrg = resolver.getCurrentMap("intermediary");
        AccessorRedirectTransformer accessorRedirectTransformer = new AccessorRedirectTransformer(srgToIntermediary);
        PatchAuditTrail jarTrail = PatchAuditTrail.create();
        List extraPatches = Stream.concat(this.adapterPatches.stream(), AccessorRedirectTransformer.PATCHES.stream()).toList();
        ConnectorRefmapHolder refmapHolder = new ConnectorRefmapHolder(refmap.merged(), refmap.files());
        int fabricLVTCompatibility = FabricMixinBootstrap.MixinConfigDecorator.getMixinCompat(metadata.modMetadata());
        PatchEnvironment environment = PatchEnvironment.create((RefmapHolder)refmapHolder, this.cleanClassLookup, this.bfu.unwrap(), fabricLVTCompatibility, jarTrail);
        MixinPatchTransformer patchTransformer = new MixinPatchTransformer(this.lvtOffsetsData, environment, extraPatches);
        RefmapRemapper refmapRemapper = new RefmapRemapper(refmap.files());
        Renamer.Builder builder = Renamer.builder().add(new JarSignatureStripper()).add(new ClassNodeTransformer(new FieldToMethodTransformer(metadata.modMetadata().getAccessWidener(), srgToIntermediary), accessorRedirectTransformer, new ReflectionRenamingTransformer(intermediaryToSrg, IntermediateMapping.get("intermediary")))).add(new OptimizedRenamingTransformer(this.enhancedRemapper, false, metadata.refmaps().isEmpty())).add(new ClassNodeTransformer(new ClassAnalysingTransformer())).add(patchTransformer).add(refmapRemapper).logger(s -> LOGGER.trace(JarTransformer.TRANSFORM_MARKER, s)).debug(s -> LOGGER.trace(JarTransformer.TRANSFORM_MARKER, s)).ignoreJarPathPrefix("assets/", "data/");
        if (!metadata.containsAT()) {
            builder.add(new AccessWidenerTransformer(metadata.modMetadata().getAccessWidener(), resolver, IntermediateMapping.get("intermediary")));
        }
        try (Renamer renamer = builder.build();){
            accessorRedirectTransformer.analyze(input, metadata.mixinPackages(), environment);
            renamer.run(input, output.toFile());
            try (FileSystem zipFile = FileSystems.newFileSystem(output);){
                patchTransformer.finalize(zipFile.getPath("/", new String[0]), metadata.mixinConfigs(), refmap.files(), refmapHolder.getDirtyRefmaps());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Encountered error while transforming jar file {}", (Object)input.getAbsolutePath(), (Object)t);
            throw t;
        }
        stopwatch.stop();
        LOGGER.debug(JarTransformer.TRANSFORM_MARKER, "Jar {} transformed in {} ms", (Object)input.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.auditTrail.merge(jarTrail);
        return jarTrail;
    }

    private static void processGeneratedJar(File input, Path output, Stopwatch stopwatch) throws IOException {
        Files.copy(input.toPath(), output, new CopyOption[0]);
        stopwatch.stop();
        LOGGER.debug(JarTransformer.TRANSFORM_MARKER, "Skipping transformation of jar {} after {} ms as it contains generated metadata, assuming it's a java library", (Object)input.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private static ClassLookup createCleanClassLookup() {
        String mcAndNeoFormVersion = FMLLoader.versionInfo().mcAndNeoFormVersion();
        if (FMLEnvironment.production) {
            MavenCoordinate coords = new MavenCoordinate("net.minecraft", FMLEnvironment.dist.isClient() ? "client" : "server", "", "srg", mcAndNeoFormVersion);
            Path path = LibraryFinder.findPathForMaven((MavenCoordinate)coords);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new ModLoadingException(ModLoadingIssue.error((String)"fml.modloadingissue.corrupted_installation", (Object[])new Object[0]).withAffectedPath(path));
            }
            ZipFile zipFile = (ZipFile)LambdaExceptionUtils.uncheck(() -> new ZipFile(path.toFile()));
            return new ZipClassLookup(zipFile);
        }
        Path cleanPath = Optional.ofNullable(System.getProperty("connector.clean.path")).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseThrow(() -> new RuntimeException("Could not determine clean minecraft artifact path"));
        return new SimpleClassLookup(ClassProvider.fromPaths(cleanPath));
    }

    public void saveAuditReport() {
        try {
            Path path = ConnectorUtil.CONNECTOR_FOLDER.resolve("patch_audit.txt");
            Files.deleteIfExists(path);
            String log = this.auditTrail.getCompleteReport();
            Files.writeString(path, (CharSequence)log, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error writing patch audit report", (Throwable)e);
        }
    }
}

