/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import com.google.common.collect.ImmutableList;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.sinytra.adapter.patch.LVTOffsets;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MixinClassGenerator;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.fixes.FieldTypePatchTransformer;
import org.sinytra.adapter.patch.fixes.FieldTypeUsageTransformer;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicAnonymousShadowFieldTypePatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicInheritedInjectionPointPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicInjectorOrdinalPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicLVTPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicModifyVarAtReturnPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicSyntheticInstanceofPatch;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicInjectionPointPatch;
import org.sinytra.connector.transformer.MappingAwareReferenceMapper;
import org.sinytra.connector.transformer.MixinPatches;
import org.sinytra.connector.transformer.patch.EnvironmentStripperTransformer;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.Transformer;

public class MixinPatchTransformer
implements Transformer {
    private static final List<Patch> PRIORITY_PATCHES = MixinPatches.getPriorityPatches();
    private static final List<Patch> PATCHES = MixinPatches.getPatches();
    private static final List<ClassTransform> CLASS_TRANSFORMS = List.of(new EnvironmentStripperTransformer(), new FieldTypeUsageTransformer());
    private static final Patch CLASS_PATCH = ((Patch.ClassPatchBuilder)Patch.builder().transform(CLASS_TRANSFORMS)).build();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean completedSetup = false;
    private final PatchEnvironment environment;
    private final List<? extends Patch> patches;

    public MixinPatchTransformer(LVTOffsets lvtOffsets, PatchEnvironment environment, List<? extends Patch> adapterPatches) {
        this.environment = environment;
        this.patches = ImmutableList.builder().addAll(PRIORITY_PATCHES).addAll(adapterPatches).addAll(PATCHES).add((Object[])new Patch[]{((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)Patch.builder().transform(new DynamicInjectorOrdinalPatch())).transform(new DynamicLVTPatch(() -> lvtOffsets))).transform(new DynamicAnonymousShadowFieldTypePatch())).transform(new DynamicModifyVarAtReturnPatch())).transform(new DynamicInheritedInjectionPointPatch())).transform(new DynamicSyntheticInstanceofPatch())).transform(new DynamicInjectionPointPatch())).build(), ((Patch.InterfacePatchBuilder)Patch.interfaceBuilder().transform(new FieldTypePatchTransformer())).build()}).build();
    }

    public void finalize(Path zipRoot, Collection<String> configs, Map<String, MappingAwareReferenceMapper.SimpleRefmap> refmapFiles, Set<String> dirtyRefmaps) throws IOException {
        Path services;
        Map<String, MixinClassGenerator.GeneratedClass> generatedMixinClasses = this.environment.classGenerator().getGeneratedMixinClasses();
        if (!generatedMixinClasses.isEmpty()) {
            for (String config : configs) {
                Path entry = zipRoot.resolve(config);
                if (!Files.exists(entry, new LinkOption[0])) continue;
                try {
                    BufferedReader reader = Files.newBufferedReader(entry);
                    try {
                        String refmapName;
                        String pkg;
                        Map<String, MixinClassGenerator.GeneratedClass> mixins;
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        JsonObject json = element.getAsJsonObject();
                        if (!json.has("package") || (mixins = this.getMixinsInPackage(pkg = json.get("package").getAsString(), generatedMixinClasses)).isEmpty()) continue;
                        JsonArray jsonMixins = json.has("mixins") ? json.get("mixins").getAsJsonArray() : new JsonArray();
                        LOGGER.info("Adding {} mixins to config {}", (Object)mixins.size(), (Object)config);
                        mixins.keySet().forEach(arg_0 -> ((JsonArray)jsonMixins).add(arg_0));
                        json.add("mixins", (JsonElement)jsonMixins);
                        String output = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)json);
                        Files.writeString(entry, (CharSequence)output, StandardCharsets.UTF_8, new OpenOption[0]);
                        if (!json.has("refmap") || !dirtyRefmaps.contains(refmapName = json.get("refmap").getAsString())) continue;
                        MappingAwareReferenceMapper.SimpleRefmap refmap = refmapFiles.get(refmapName);
                        Path path2 = zipRoot.resolve(refmapName);
                        if (!Files.exists(path2, new LinkOption[0])) continue;
                        String refmapString = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((Object)refmap);
                        Files.writeString(path2, (CharSequence)refmapString, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        if (Files.exists(services = zipRoot.resolve("META-INF/services"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(services, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(LambdaExceptionUtils.rethrowConsumer(path -> {
                    String serviceName = path.getFileName().toString();
                    List<String> providers = Files.readAllLines(path);
                    List<String> existingProviders = providers.stream().filter(cls -> Files.exists(zipRoot.resolve(cls.replace('.', '/') + ".class"), new LinkOption[0])).toList();
                    int diff = providers.size() - existingProviders.size();
                    if (diff > 0) {
                        LOGGER.debug("Removing {} nonexistent service providers for service {}", (Object)diff, (Object)serviceName);
                        if (existingProviders.isEmpty()) {
                            Files.delete(path);
                        } else {
                            String newText = String.join((CharSequence)"\n", existingProviders);
                            Files.writeString(path, (CharSequence)newText, StandardCharsets.UTF_8, new OpenOption[0]);
                        }
                    }
                }));
            }
        }
    }

    private Map<String, MixinClassGenerator.GeneratedClass> getMixinsInPackage(String mixinPackage, Map<String, MixinClassGenerator.GeneratedClass> generatedMixinClasses) {
        HashMap<String, MixinClassGenerator.GeneratedClass> classes = new HashMap<String, MixinClassGenerator.GeneratedClass>();
        for (Map.Entry<String, MixinClassGenerator.GeneratedClass> entry : generatedMixinClasses.entrySet()) {
            String name = entry.getKey();
            String className = name.replace('/', '.');
            if (!className.startsWith(mixinPackage)) continue;
            String specificPart = className.substring(mixinPackage.length() + 1);
            classes.put(specificPart, entry.getValue());
            generatedMixinClasses.remove(name);
        }
        return classes;
    }

    public static void completeSetup(Collection<IModFile> mods) {
        if (completedSetup) {
            return;
        }
        String[] targetClasses = (String[])mods.stream().filter(m -> m.getModFileInfo() != null && !m.getModInfos().isEmpty() && ((IModInfo)m.getModInfos().get(0)).getModId().equals("neoforge")).map(m -> m.findResource(new String[]{"coremods/finalize_spawn_targets.json"})).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(LambdaExceptionUtils.rethrowFunction(path -> {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                return jsonElement;
            }
        })).filter(JsonElement::isJsonArray).flatMap(json -> json.getAsJsonArray().asList().stream().map(JsonElement::getAsString)).toArray(String[]::new);
        if (targetClasses.length > 0) {
            // empty if block
        }
        completedSetup = true;
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        Patch.Result patchResult = Patch.Result.PASS;
        ClassReader reader = new ClassReader(entry.getData());
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (MixinPatchTransformer.isMixinClass(node)) {
            patchResult = patchResult.or(CLASS_PATCH.apply(node, this.environment));
            for (Patch patch : this.patches) {
                patchResult = patchResult.or(patch.apply(node, this.environment));
            }
        } else {
            for (ClassTransform classTransform : CLASS_TRANSFORMS) {
                patchResult = patchResult.or(classTransform.apply(node, null, PatchContext.create(node, List.of(), this.environment)));
            }
        }
        if (patchResult != Patch.Result.PASS) {
            ClassWriter writer = new ClassWriter(1 | (patchResult == Patch.Result.COMPUTE_FRAMES ? 2 : 0));
            node.accept((ClassVisitor)writer);
            return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
        }
        return entry;
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        ArrayList entries = new ArrayList();
        ImmutableList patches = ImmutableList.builder().add((Object)((Patch.ClassPatchBuilder)Patch.builder().transform(new DynamicInheritedInjectionPointPatch())).build()).build();
        this.environment.classGenerator().getGeneratedMixinClasses().forEach((arg_0, arg_1) -> this.lambda$getExtras$10((List)patches, entries, arg_0, arg_1));
        return entries;
    }

    private static boolean isMixinClass(ClassNode classNode) {
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                if (!annotation.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
                return true;
            }
        }
        return false;
    }

    private /* synthetic */ void lambda$getExtras$10(List patches, List entries, String name, MixinClassGenerator.GeneratedClass cls) {
        for (Patch patch : patches) {
            patch.apply(cls.node(), this.environment);
        }
        ClassWriter writer = new ClassWriter(3);
        cls.node().accept((ClassVisitor)writer);
        byte[] bytes = writer.toByteArray();
        entries.add(Transformer.ClassEntry.create(name + ".class", 318211200000L, bytes));
    }
}

