/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.impl.metadata.NestedJarEntry;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.JarInJarDependencyLocator;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.ConnectorEarlyLoader;
import org.sinytra.connector.locator.ConnectorFabricModMetadata;
import org.sinytra.connector.locator.DependencyResolver;
import org.sinytra.connector.locator.FabricModMetadataParser;
import org.sinytra.connector.locator.FabricModsDiscoverer;
import org.sinytra.connector.locator.MixinTransformSafeguard;
import org.sinytra.connector.locator.filter.ForgeModPackageFilter;
import org.sinytra.connector.locator.filter.SplitPackageMerger;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.sinytra.connector.util.ConnectorUtil;
import org.sinytra.connector.util.PriorityModLoadingException;
import org.slf4j.Logger;

public class ConnectorLocator
implements IDependencyLocator {
    public static final String PLACEHOLDER_PROPERTY = "connector:placeholder";
    private static final Logger LOGGER = LogUtils.getLogger();

    public int getPriority() {
        return -1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMods(List<IModFile> loadedMods, IDiscoveryPipeline pipeline) {
        if (ConnectorEarlyLoader.hasEncounteredException()) {
            LOGGER.error("Skipping mod scan due to previously encountered error");
            return;
        }
        try {
            List<IModFile> results = this.locateFabricMods(loadedMods);
            if (results != null) {
                results.forEach(arg_0 -> ((IDiscoveryPipeline)pipeline).addModFile(arg_0));
                Path generatedAdapterJar = JarTransformer.getGeneratedJarPath();
                if (Files.exists(generatedAdapterJar, new LinkOption[0])) {
                    pipeline.addPath(generatedAdapterJar, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR);
                }
            }
            ConnectorLocator.loadEmbeddedJars(pipeline);
        }
        catch (PriorityModLoadingException e) {
            throw e;
        }
        catch (ModLoadingException e) {
            ConnectorEarlyLoader.addGenericLoadingException(e.getIssues());
        }
        catch (Throwable t) {
            StartupNotificationManager.addModMessage((String)"CONNECTOR LOCATOR ERROR");
            LOGGER.error("Connector locator error", t);
            ConnectorEarlyLoader.addGenericLoadingException(ConnectorEarlyLoader.createGenericLoadingIssue(t, "Fabric mod discovery failed"));
        }
        finally {
            ForgeModPackageFilter.filterPackages(loadedMods);
        }
    }

    @Nullable
    private List<IModFile> locateFabricMods(List<IModFile> discoveredMods) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)FMLPaths.MODSDIR.get());
        Path tempDir = ConnectorUtil.CONNECTOR_FOLDER.resolve("temp");
        Collection<SimpleModInfo> loadedModInfos = ConnectorLocator.getPreviouslyDiscoveredMods(discoveredMods);
        List<IModFile> loadedModFiles = loadedModInfos.stream().map(SimpleModInfo::origin).toList();
        Collection loadedModIds = loadedModInfos.stream().filter(mod -> !mod.library()).map(SimpleModInfo::modid).collect(Collectors.toUnmodifiableSet());
        List<JarTransformer.TransformableJar> discoveredJars = FabricModsDiscoverer.scanFabricMods().map(LambdaExceptionUtils.rethrowFunction(p -> JarTransformer.cacheTransformableJar(p.toFile()))).filter(jar -> {
            ConnectorFabricModMetadata metadata = jar.modPath().metadata().modMetadata();
            return !ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds);
        }).toList();
        HashMultimap parentToChildren = HashMultimap.create();
        List<JarTransformer.TransformableJar> discoveredNestedJars = discoveredJars.stream().flatMap(arg_0 -> ConnectorLocator.lambda$locateFabricMods$3(loadedModIds, tempDir, (Multimap)parentToChildren, arg_0)).toList();
        ArrayList ignoredModFiles = new ArrayList();
        List<JarTransformer.TransformableJar> uniqueJars = ConnectorLocator.handleDuplicateMods(discoveredJars, discoveredNestedJars, loadedModInfos, ignoredModFiles);
        List<JarTransformer.TransformableJar> candidates = DependencyResolver.resolveDependencies(uniqueJars, (Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar>)parentToChildren, loadedModFiles);
        List<Path> renameLibs = loadedModFiles.stream().map(modFile -> modFile.getSecureJar().getRootPath()).toList();
        List<JarTransformer.TransformedFabricModPath> transformed = JarTransformer.transform(candidates, renameLibs, loadedModFiles);
        List<JarTransformer.TransformedFabricModPath> failing = transformed.stream().filter(j -> j.auditTrail() != null && j.auditTrail().hasFailingMixins()).toList();
        if (!failing.isEmpty()) {
            MixinTransformSafeguard.trigger(failing);
        }
        if (ConnectorEarlyLoader.hasEncounteredException()) {
            StartupNotificationManager.addModMessage((String)"JAR TRANSFORMATION ERROR");
            LOGGER.error("Cancelling jar discovery due to previous error");
            return null;
        }
        List<SplitPackageMerger.FilteredModPath> moduleSafeJars = SplitPackageMerger.mergeSplitPackages(transformed.stream().map(JarTransformer.TransformedFabricModPath::output).toList(), loadedModFiles, ignoredModFiles);
        return moduleSafeJars.stream().map(ConnectorLocator::createConnectorModFile).toList();
    }

    private static IModFile createConnectorModFile(SplitPackageMerger.FilteredModPath modPath) {
        JarContents jarContents = new JarContentsBuilder().paths(modPath.paths()).pathFilter(modPath.filter()).build();
        if (modPath.metadata().generated()) {
            return IModFile.create((SecureJar)SecureJar.from((JarContents)jarContents), JarModsDotTomlModFileReader::manifestParser, (IModFile.Type)IModFile.Type.LIBRARY, (ModFileDiscoveryAttributes)ModFileDiscoveryAttributes.DEFAULT);
        }
        ModJarMetadata modJarMetadata = new ModJarMetadata(jarContents);
        SecureJar secureJar = SecureJar.from((JarContents)jarContents, (JarMetadata)modJarMetadata);
        IModFile modFile = IModFile.create((SecureJar)secureJar, f -> FabricModMetadataParser.createForgeMetadata(f, modPath.metadata().modMetadata(), modPath.metadata().visibleMixinConfigs(), modPath.metadata().generated()));
        modJarMetadata.setModFile(modFile);
        return modFile;
    }

    private static Stream<JarTransformer.TransformableJar> discoverNestedJarsRecursive(Path tempDir, JarTransformer.TransformableJar parent, Collection<NestedJarEntry> jars, Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar> parentToChildren, Collection<String> loadedModIds) {
        SecureJar secureJar = SecureJar.from((Path[])new Path[]{parent.input().toPath()});
        return jars.stream().map(entry -> secureJar.getPath(entry.getFile(), new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(path -> {
            JarTransformer.TransformableJar jar = (JarTransformer.TransformableJar)LambdaExceptionUtils.uncheck(() -> ConnectorLocator.prepareNestedJar(tempDir, secureJar.getPrimaryPath().getFileName().toString(), path));
            ConnectorFabricModMetadata metadata = jar.modPath().metadata().modMetadata();
            if (ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds)) {
                return Stream.empty();
            }
            parentToChildren.put((Object)parent, (Object)jar);
            return Stream.concat(Stream.of(jar), ConnectorLocator.discoverNestedJarsRecursive(tempDir, jar, metadata.getJars(), parentToChildren, loadedModIds));
        });
    }

    private static JarTransformer.TransformableJar prepareNestedJar(Path tempDir, String parentName, Path path) throws IOException {
        Files.createDirectories(tempDir, new FileAttribute[0]);
        String parentNameWithoutExt = parentName.split("\\.(?!.*\\.)")[0];
        Path extracted = tempDir.resolve(parentNameWithoutExt + "$" + path.getFileName().toString());
        ConnectorUtil.cache(path, extracted, () -> Files.copy(path, extracted, new CopyOption[0]));
        return (JarTransformer.TransformableJar)LambdaExceptionUtils.uncheck(() -> JarTransformer.cacheTransformableJar(extracted.toFile()));
    }

    private static List<JarTransformer.TransformableJar> handleDuplicateMods(List<JarTransformer.TransformableJar> rootMods, List<JarTransformer.TransformableJar> nestedMods, Collection<SimpleModInfo> loadedMods, Collection<? super IModFile> ignoredModFiles) {
        return Stream.concat(rootMods.stream(), nestedMods.stream()).filter(jar -> {
            DefaultArtifactVersion artifactVersion;
            SimpleModInfo fabricModInfo;
            List<SimpleModInfo> modsByVersion;
            String id = jar.modPath().metadata().modMetadata().getId();
            List<SimpleModInfo> forgeMods = loadedMods.stream().filter(mod -> mod.modid().equals(id)).toList();
            if (forgeMods.stream().anyMatch(SimpleModInfo::library) && (modsByVersion = Stream.concat(Stream.of(fabricModInfo = new SimpleModInfo(id, (ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(jar.modPath().metadata().modMetadata().getVersion().getFriendlyString())), false, null)), forgeMods.stream()).sorted(Comparator.comparing(SimpleModInfo::version).reversed()).toList()).getFirst() == fabricModInfo) {
                modsByVersion.subList(1, modsByVersion.size()).forEach(mod -> {
                    IModFile modFile = Objects.requireNonNull(mod.origin(), "Missing mod origin for mod " + mod.modid());
                    ignoredModFiles.add(modFile);
                });
                return true;
            }
            if (loadedMods.stream().anyMatch(mod -> mod.modid().equals(id))) {
                LOGGER.info(LogMarkers.SCAN, "Removing duplicate mod {} in file {}", (Object)id, (Object)jar.modPath().path().toAbsolutePath());
                return false;
            }
            return true;
        }).toList();
    }

    private static boolean shouldIgnoreMod(ConnectorFabricModMetadata metadata, Collection<String> loadedModIds) {
        String id = metadata.getId();
        return ConnectorUtil.DISABLED_MODS.contains(id) || loadedModIds.contains(id);
    }

    private static Collection<SimpleModInfo> getPreviouslyDiscoveredMods(List<IModFile> discoveredMods) {
        return discoveredMods.stream().flatMap(modFile -> Optional.ofNullable(modFile.getModFileInfo()).stream()).flatMap(modFileInfo -> {
            IModFile modFile = modFileInfo.getFile();
            List modInfos = modFileInfo.getMods();
            if (modFileInfo.getFileProperties().containsKey(PLACEHOLDER_PROPERTY)) {
                modInfos.forEach(mod -> mod.getVersion().parseVersion("0.0"));
                return Stream.empty();
            }
            if (!modInfos.isEmpty()) {
                return modInfos.stream().map(modInfo -> new SimpleModInfo(modInfo.getModId(), modInfo.getVersion(), false, modFile));
            }
            String version = modFileInfo.getFile().getSecureJar().moduleDataProvider().descriptor().version().map(ModuleDescriptor.Version::toString).orElse("0.0");
            return Stream.of(new SimpleModInfo(modFileInfo.moduleName(), (ArtifactVersion)new DefaultArtifactVersion(version), true, modFile));
        }).toList();
    }

    private static void loadEmbeddedJars(IDiscoveryPipeline pipeline) throws Exception {
        SecureJar secureJar = SecureJar.from((Path[])new Path[]{Path.of(ConnectorLocator.class.getProtectionDomain().getCodeSource().getLocation().toURI())});
        IModFile modFile = IModFile.create((SecureJar)secureJar, JarModsDotTomlModFileReader::manifestParser);
        new JarInJarDependencyLocator().scanMods(List.of(modFile), pipeline);
    }

    private static /* synthetic */ Stream lambda$locateFabricMods$3(Collection loadedModIds, Path tempDir, Multimap parentToChildren, JarTransformer.TransformableJar jar) {
        ConnectorFabricModMetadata metadata = jar.modPath().metadata().modMetadata();
        return ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds) ? Stream.empty() : ConnectorLocator.discoverNestedJarsRecursive(tempDir, jar, metadata.getJars(), (Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar>)parentToChildren, loadedModIds);
    }

    private record SimpleModInfo(String modid, ArtifactVersion version, boolean library, @Nullable IModFile origin) {
    }
}

