/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.DisableMixin;
import org.sinytra.adapter.patch.transformer.operation.ModifyMixinType;

public class DynamicSyntheticInstanceofPatch
implements MethodTransform {
    private static final int RANGE = 4;

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/Redirect;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        if (methodContext.injectionPointAnnotation().getValue("value").map(v -> !((String)v.get()).equals("INVOKE")).orElse(true).booleanValue()) {
            return Patch.Result.PASS;
        }
        if (!methodContext.failsDirtyInjectionCheck()) {
            return Patch.Result.PASS;
        }
        List<AbstractInsnNode> insns = methodContext.findInjectionTargetInsns(methodContext.findCleanInjectionTarget());
        if (insns.size() != 1) {
            return Patch.Result.PASS;
        }
        AbstractInsnNode targetInsn = insns.getFirst();
        List<AbstractInsnNode> labelInsns = DynamicSyntheticInstanceofPatch.findLabelInsns(targetInsn);
        AbstractInsnNode jumpInsn = labelInsns.getLast();
        if (!(jumpInsn instanceof JumpInsnNode)) {
            return Patch.Result.PASS;
        }
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findForwardInstructions(targetInsn, 4);
        int firstOp = cleanMatcher.after().getFirst().getOpcode();
        InsnList dirtyInsns = methodContext.findDirtyInjectionTarget().methodNode().instructions;
        for (AbstractInsnNode insn : dirtyInsns) {
            InstructionMatcher finalDirtyMatcher;
            AbstractInsnNode nextLabel;
            InstructionMatcher dirtyMatcher;
            if (insn.getOpcode() != firstOp || !cleanMatcher.test(dirtyMatcher = MethodCallAnalyzer.findForwardInstructions(nextLabel = DynamicSyntheticInstanceofPatch.findInsnAfterLabel(insn), 4))) continue;
            if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;")) {
                TypeInsnNode instanceOfInsn = DynamicSyntheticInstanceofPatch.findLabelInsns(insn).stream().filter(i -> i.getOpcode() == 193).findFirst().orElse(null);
                if (instanceOfInsn == null) {
                    return Patch.Result.PASS;
                }
                ModifyMixinType transform = new ModifyMixinType("Lorg/sinytra/adapter/runtime/inject/ModifyInstanceofValue;", b -> {
                    b.sameTarget().injectionPoint("sinytra:INSTANCEOF", instanceOfInsn.desc);
                    int ordinal = DynamicSyntheticInstanceofPatch.getInstanceofOrdinal(dirtyInsns, (AbstractInsnNode)instanceOfInsn);
                    if (ordinal != 0) {
                        b.putValue("ordinal", ordinal);
                    }
                });
                return transform.apply(classNode, methodNode, methodContext, context);
            }
            List<AbstractInsnNode> dirtyLabelInsns = DynamicSyntheticInstanceofPatch.findLabelInsns(insn);
            ArrayList<AbstractInsnNode> modLabelInsns = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode ins : methodNode.instructions) {
                if (ins instanceof LineNumberNode || ins instanceof FrameNode) continue;
                modLabelInsns.add(ins.clone(Map.of()));
            }
            modLabelInsns.removeFirst();
            modLabelInsns.removeLast();
            dirtyLabelInsns.removeLast();
            modLabelInsns.removeLast();
            InstructionMatcher finalCleanMatcher = new InstructionMatcher(null, dirtyLabelInsns, List.of());
            if (!finalCleanMatcher.test(finalDirtyMatcher = new InstructionMatcher(null, modLabelInsns, List.of()), 1)) continue;
            return new DisableMixin().apply(classNode, methodNode, methodContext, context);
        }
        return Patch.Result.PASS;
    }

    private static AbstractInsnNode findInsnAfterLabel(AbstractInsnNode insn) {
        AbstractInsnNode next;
        for (next = insn.getNext(); next != null && !(next instanceof LabelNode); next = next.getNext()) {
        }
        return next;
    }

    private static List<AbstractInsnNode> findLabelInsns(AbstractInsnNode insn) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        if (!(insn instanceof LabelNode)) {
            for (AbstractInsnNode prev = insn.getPrevious(); prev != null && !(prev instanceof LabelNode); prev = prev.getPrevious()) {
                if (prev instanceof FrameNode || prev instanceof LineNumberNode) continue;
                list.add(prev);
            }
        }
        for (AbstractInsnNode next = insn.getNext(); next != null && !(next instanceof LabelNode); next = next.getNext()) {
            if (next instanceof FrameNode || next instanceof LineNumberNode) continue;
            list.add(next);
        }
        return list;
    }

    private static int getInstanceofOrdinal(InsnList insns, AbstractInsnNode insn) {
        ArrayList<AbstractInsnNode> instanceOfInsns = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode node : insns) {
            if (node.getOpcode() != 193) continue;
            instanceOfInsns.add(insn);
        }
        return instanceOfInsns.indexOf(insn);
    }
}

