/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGColoredTintedGlassBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.CGTintedGlassBlock;
import com.supermartijn642.connectedglass.ConnectedGlass;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public enum CGGlassType {
    BORDERLESS_GLASS(false, true, "Connecting"),
    CLEAR_GLASS(false, true, "Clear"),
    SCRATCHED_GLASS(false, true, "Scratched"),
    TINTED_BORDERLESS_GLASS(true, false, "Connecting Tinted");

    private final String identifier;
    public final boolean isTinted;
    public final boolean hasPanes;
    public final String translation;
    public CGGlassBlock block;
    public final List<CGGlassBlock> blocks = new ArrayList<CGGlassBlock>();
    public final EnumMap<DyeColor, CGColoredGlassBlock> colored_blocks = new EnumMap(DyeColor.class);
    public CGPaneBlock pane;
    public final List<CGPaneBlock> panes = new ArrayList<CGPaneBlock>();
    public final EnumMap<DyeColor, CGColoredPaneBlock> colored_panes = new EnumMap(DyeColor.class);

    private CGGlassType(boolean isTinted, boolean hasPanes, String translation) {
        this.identifier = this.name().toLowerCase(Locale.ROOT);
        this.isTinted = isTinted;
        this.hasPanes = hasPanes;
        this.translation = translation;
    }

    public String getRegistryName() {
        return this.identifier;
    }

    public String getRegistryName(DyeColor color) {
        return color == null ? this.getRegistryName() : this.getRegistryName() + "_" + color.getName().toLowerCase(Locale.ROOT);
    }

    public String getPaneRegistryName() {
        return this.getRegistryName() + "_pane";
    }

    public String getPaneRegistryName(DyeColor color) {
        return color == null ? this.getPaneRegistryName() : this.getRegistryName(color) + "_pane";
    }

    public void registerBlocks(RegistrationHandler.Helper<Block> helper) {
        this.block = (CGGlassBlock)((Object)helper.register(this.getRegistryName(), (Object)(this.isTinted ? new CGTintedGlassBlock(this.name().toLowerCase(Locale.ROOT), true) : new CGGlassBlock(this.name().toLowerCase(Locale.ROOT), true))));
        this.blocks.add(this.block);
        if (this.hasPanes) {
            this.pane = (CGPaneBlock)((Object)helper.register(this.getPaneRegistryName(), (Object)new CGPaneBlock(this.block)));
            this.panes.add(this.pane);
        }
        for (DyeColor color : DyeColor.values()) {
            CGColoredGlassBlock block = (CGColoredGlassBlock)((Object)helper.register(this.getRegistryName(color), (Object)(this.isTinted ? new CGColoredTintedGlassBlock(this.name().toLowerCase(Locale.ROOT) + "_" + color.name().toLowerCase(Locale.ROOT), true, color) : new CGColoredGlassBlock(this.name().toLowerCase(Locale.ROOT) + "_" + color.name().toLowerCase(Locale.ROOT), true, color))));
            this.blocks.add(block);
            this.colored_blocks.put(color, block);
            if (!this.hasPanes) continue;
            CGColoredPaneBlock pane = (CGColoredPaneBlock)((Object)helper.register(this.getPaneRegistryName(color), (Object)new CGColoredPaneBlock(block)));
            this.panes.add(pane);
            this.colored_panes.put(color, pane);
        }
    }

    public void registerItems(RegistrationHandler.Helper<Item> helper) {
        this.blocks.forEach(block -> {
            ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)block);
            helper.register(identifier.getPath(), (Object)new BaseBlockItem((Block)block, ItemProperties.create().group((CreativeModeTab)ConnectedGlass.GROUP)));
        });
        this.panes.forEach(pane -> {
            ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)pane);
            helper.register(identifier.getPath(), (Object)new BaseBlockItem((Block)pane, ItemProperties.create().group((CreativeModeTab)ConnectedGlass.GROUP)));
        });
    }

    public CGGlassBlock getBlock() {
        return this.block;
    }

    public CGGlassBlock getBlock(DyeColor color) {
        if (color == null) {
            return this.block;
        }
        return this.colored_blocks.get(color);
    }

    public CGPaneBlock getPane() {
        return this.pane;
    }

    public CGPaneBlock getPane(DyeColor color) {
        if (color == null) {
            return this.pane;
        }
        return this.colored_panes.get(color);
    }
}

