/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.client.gui;

import net.combat_roll.client.CombatRollClient;
import net.combat_roll.client.gui.HudElement;
import net.combat_roll.client.gui.HudRenderHelper;
import net.combat_roll.config.HudConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public class HudConfigScreen
extends Screen {
    private Screen previous;

    public HudConfigScreen(Screen previous) {
        super((Component)Component.translatable((String)"gui.combat_roll.hud"));
        this.previous = previous;
    }

    protected void init() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonCenterX = this.width / 2 - buttonWidth / 2;
        int buttonCenterY = this.height / 2 - buttonHeight / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.combat_roll.close"), button -> this.onClose()).pos(buttonCenterX, buttonCenterY - 30).size(buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.combat_roll.corner"), button -> HudConfigScreen.nextOrigin()).pos(buttonCenterX, buttonCenterY).size(buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.combat_roll.reset"), button -> this.reset()).pos(buttonCenterX, buttonCenterY + 30).size(buttonWidth, buttonHeight).build());
    }

    public void onClose() {
        this.save();
        this.minecraft.setScreen(this.previous);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        HudRenderHelper.render(context, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isDragging() && button == 0) {
            HudConfig config = (HudConfig)CombatRollClient.hudConfig.value;
            config.rollWidget.offset = new Vec2((float)((double)config.rollWidget.offset.x + deltaX), (float)((double)config.rollWidget.offset.y + deltaY));
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static void nextOrigin() {
        HudConfig config = (HudConfig)CombatRollClient.hudConfig.value;
        try {
            HudElement.Origin origin = HudElement.Origin.values()[config.rollWidget.origin.ordinal() + 1];
            config.rollWidget = new HudElement(origin, origin.initialOffset());
        }
        catch (Exception e) {
            HudElement.Origin origin = HudElement.Origin.values()[0];
            config.rollWidget = new HudElement(origin, origin.initialOffset());
        }
    }

    public void save() {
        CombatRollClient.hudConfig.save();
    }

    public void reset() {
        HudConfig config = (HudConfig)CombatRollClient.hudConfig.value;
        config.rollWidget = HudConfig.createDefaultRollWidget();
    }
}

