/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.client;

import com.google.gson.Gson;
import net.combat_roll.CombatRollMod;
import net.combat_roll.client.RollEffect;
import net.combat_roll.config.ServerConfig;
import net.combat_roll.internals.RollingEntity;
import net.combat_roll.network.Packets;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ClientNetwork {
    public static void handleRollAnimation(Packets.RollAnimation packet) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            Entity entity = client.level.getEntity(packet.playerId());
            if (entity instanceof Player) {
                Player player = (Player)entity;
                RollEffect.playVisuals(packet.visuals(), player, packet.velocity());
            }
        });
    }

    public static void handleConfigSync(Packets.ConfigSync packet) {
        ServerConfig config;
        Minecraft client = Minecraft.getInstance();
        RollingEntity rollingPlayer = (RollingEntity)client.player;
        if (rollingPlayer != null) {
            rollingPlayer.getRollManager().isEnabled = true;
        }
        Gson gson = new Gson();
        CombatRollMod.config = config = (ServerConfig)gson.fromJson(packet.json(), ServerConfig.class);
    }
}

