/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;

public class AttributeModifierHelper {
    @NotNull
    public static Multimap<Holder<Attribute>, AttributeModifier> modifierMultimap(ItemStack itemStack) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        HashMultimap modifiersMap = HashMultimap.create();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            modifiersMap.put((Object)entry.attribute(), (Object)entry.modifier());
        }
        return modifiersMap;
    }

    @NotNull
    public static Multimap<Holder<Attribute>, AttributeModifier> fromModifier(Holder<Attribute> attribute, AttributeModifier modifier) {
        HashMultimap modifiersMap = HashMultimap.create();
        modifiersMap.put(attribute, (Object)modifier);
        return modifiersMap;
    }
}

