/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.logic.AnimatedHand;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Packets {

    public record Ack(String code) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"ack");
        public static final CustomPacketPayload.Type<Ack> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, Ack> CODEC = StreamCodec.ofMember(Ack::write, Ack::read);

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.code);
        }

        public static Ack read(FriendlyByteBuf buffer) {
            String code = buffer.readUtf();
            return new Ack(code);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record ConfigSync(String json) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"config_sync");
        public static final CustomPacketPayload.Type<ConfigSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, ConfigSync> CODEC = StreamCodec.ofMember(ConfigSync::write, ConfigSync::read);
        private static final Gson gson = new Gson();

        public static String serialize(ServerConfig config) {
            return gson.toJson((Object)config);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.json);
        }

        public static ConfigSync read(FriendlyByteBuf buffer) {
            String json = buffer.readUtf();
            return new ConfigSync(json);
        }

        public ServerConfig deserialized() {
            return (ServerConfig)gson.fromJson(this.json, ServerConfig.class);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record C2S_BlockHit(BlockPos pos) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"block_hit");
        public static final CustomPacketPayload.Type<C2S_BlockHit> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, C2S_BlockHit> CODEC = BlockPos.STREAM_CODEC.map(C2S_BlockHit::new, C2S_BlockHit::pos).cast();

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record WeaponRegistrySync(boolean compressed, List<String> chunks) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"weapon_registry");
        public static final CustomPacketPayload.Type<WeaponRegistrySync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, WeaponRegistrySync> CODEC = StreamCodec.ofMember(WeaponRegistrySync::write, WeaponRegistrySync::read);

        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.compressed);
            buffer.writeInt(this.chunks.size());
            for (String chunk : this.chunks) {
                buffer.writeUtf(chunk);
            }
        }

        public static WeaponRegistrySync read(FriendlyByteBuf buffer) {
            boolean compressed = buffer.readBoolean();
            int chunkCount = buffer.readInt();
            ArrayList<String> chunks = new ArrayList<String>();
            for (int i = 0; i < chunkCount; ++i) {
                chunks.add(buffer.readUtf());
            }
            return new WeaponRegistrySync(compressed, chunks);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record AttackSound(double x, double y, double z, String soundId, float volume, float pitch, long seed) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"attack_sound");
        public static final CustomPacketPayload.Type<AttackSound> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, AttackSound> CODEC = StreamCodec.ofMember(AttackSound::write, AttackSound::read);

        public void write(FriendlyByteBuf buffer) {
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
            buffer.writeUtf(this.soundId);
            buffer.writeFloat(this.volume);
            buffer.writeFloat(this.pitch);
            buffer.writeLong(this.seed);
        }

        public static AttackSound read(FriendlyByteBuf buffer) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            String soundId = buffer.readUtf();
            float volume = buffer.readFloat();
            float pitch = buffer.readFloat();
            long seed = buffer.readLong();
            return new AttackSound(x, y, z, soundId, volume, pitch, seed);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record AttackAnimation(int playerId, AnimatedHand animatedHand, String animationName, float length, float upswing) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"attack_animation");
        public static final CustomPacketPayload.Type<AttackAnimation> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, AttackAnimation> CODEC = StreamCodec.ofMember(AttackAnimation::write, AttackAnimation::read);
        public static String StopSymbol = "!STOP!";

        public static AttackAnimation stop(int playerId, int length) {
            return new AttackAnimation(playerId, AnimatedHand.MAIN_HAND, StopSymbol, length, 0.0f);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.animatedHand.ordinal());
            buffer.writeUtf(this.animationName);
            buffer.writeFloat(this.length);
            buffer.writeFloat(this.upswing);
        }

        public static AttackAnimation read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            AnimatedHand animatedHand = AnimatedHand.values()[buffer.readInt()];
            String animationName = buffer.readUtf();
            float length = buffer.readFloat();
            float upswing = buffer.readFloat();
            return new AttackAnimation(playerId, animatedHand, animationName, length, upswing);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, int[] entityIds) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)"c2s_request_attack");
        public static final CustomPacketPayload.Type<C2S_AttackRequest> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2S_AttackRequest> CODEC = StreamCodec.ofMember(C2S_AttackRequest::write, C2S_AttackRequest::read);
        public static boolean UseVanillaPacket = true;

        public C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, List<Entity> entities) {
            this(comboCount, isSneaking, selectedSlot, C2S_AttackRequest.convertEntityList(entities));
        }

        private static int[] convertEntityList(List<Entity> entities) {
            int[] ids = new int[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                ids[i] = entities.get(i).getId();
            }
            return ids;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.comboCount);
            buffer.writeBoolean(this.isSneaking);
            buffer.writeInt(this.selectedSlot);
            buffer.writeVarIntArray(this.entityIds);
        }

        public static C2S_AttackRequest read(FriendlyByteBuf buffer) {
            int comboCount = buffer.readInt();
            boolean isSneaking = buffer.readBoolean();
            int selectedSlot = buffer.readInt();
            int[] ids = buffer.readVarIntArray();
            return new C2S_AttackRequest(comboCount, isSneaking, selectedSlot, ids);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

