/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.mehvahdjukaar.amendments.common.network.ClientBoundEntityHitSwayingBlockMessage;
import net.mehvahdjukaar.amendments.common.tile.SwayingBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppSquaredCompat;
import net.mehvahdjukaar.amendments.integration.ThinAirCompat;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallLanternBlock
extends WaterBlock
implements EntityBlock {
    public static final MapCodec<WallLanternBlock> CODEC = WallLanternBlock.simpleCodec(WallLanternBlock::new);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)2.0, (double)6.0, (double)11.0, (double)15.99, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    public static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<ModBlockProperties.BlockAttachment> ATTACHMENT = ModBlockProperties.BLOCK_ATTACHMENT;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public WallLanternBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(s -> (Boolean)s.getValue((Property)LIT) != false ? (Integer)s.getValue((Property)LIGHT_LEVEL) : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(15))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends WallLanternBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            ItemInteractionResult res;
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            BlockState lantern = te.getHeldBlock();
            if (CompatHandler.SUPPSQUARED && (res = SuppSquaredCompat.lightUpLantern(level, pos, player, hand, stack, te, lantern)).consumesAction()) {
                return res;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return null;
        }
        BlockState state = super.getStateForPlacement(context);
        BlockPos blockpos = context.getClickedPos();
        Level world = context.getLevel();
        Direction dir = context.getClickedFace();
        BlockPos relative = blockpos.relative(dir.getOpposite());
        BlockState facingState = world.getBlockState(relative);
        return (BlockState)WallLanternBlock.getConnectedState(state, facingState, (LevelAccessor)world, relative, dir).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity te = world.getBlockEntity(pos);
        Item i = stack.getItem();
        if (te instanceof WallLanternBlockTile) {
            WallLanternBlockTile blockHolder = (WallLanternBlockTile)te;
            if (i instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)i;
                blockHolder.setHeldBlock(blockItem.getBlock().defaultBlockState());
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing == ((Direction)stateIn.getValue((Property)FACING)).getOpposite() ? (!stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : WallLanternBlock.getConnectedState(stateIn, facingState, worldIn, facingPos, facing)) : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return ModBlockProperties.BlockAttachment.get(blockstate, blockpos, level, direction) != null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public static BlockState getConnectedState(BlockState state, BlockState facingState, LevelAccessor world, BlockPos pos, Direction dir) {
        ModBlockProperties.BlockAttachment attachment = ModBlockProperties.BlockAttachment.get(facingState, pos, (LevelReader)world, dir);
        if (attachment == null) {
            return state;
        }
        return (BlockState)state.setValue(ATTACHMENT, (Comparable)((Object)attachment));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_SOUTH;
        };
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            return new ItemStack((ItemLike)te.getHeldBlock().getBlock());
        }
        return new ItemStack((ItemLike)Blocks.LANTERN, 1);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHT_LEVEL, LIT, FACING, ATTACHMENT});
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.tick(state, level, pos, rand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            BlockState lantern;
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            if (te.isRedstoneLantern() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.hasNeighborSignal(pos)) {
                level.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
                if (te.getHeldBlock().hasProperty((Property)LIT)) {
                    te.setHeldBlock((BlockState)te.getHeldBlock().cycle((Property)LIT));
                }
            }
            if (CompatHandler.THIN_AIR && ThinAirCompat.isAirLantern(lantern = te.getHeldBlock())) {
                te.setHeldBlock(lantern);
                if (te.getHeldBlock() != lantern) {
                    level.sendBlockUpdated(pos, state, state, 3);
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean flag;
        WallLanternBlockTile tile;
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof WallLanternBlockTile && (tile = (WallLanternBlockTile)blockEntity).isRedstoneLantern() && (flag = ((Boolean)state.getValue((Property)LIT)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (flag) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
                if (tile.getHeldBlock().hasProperty((Property)LIT)) {
                    tile.setHeldBlock((BlockState)tile.getHeldBlock().cycle((Property)LIT));
                }
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)object;
            return tile.getHeldBlock().getDrops(builder);
        }
        return super.getDrops(state, builder);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
            BlockState s = tile.getHeldBlock();
            s.getBlock().animateTick(s, level, pos, random);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new WallLanternBlockTile(pPos, pState);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (level.isClientSide) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof WallLanternBlockTile) {
                WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
                tile.amendments$getAnimation().hitByEntity(entity, state, pos);
            }
        } else {
            if (entity.xo != entity.getX() || entity.zo != entity.getZ() || entity.yo != entity.getY()) {
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
            }
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ClientBoundEntityHitSwayingBlockMessage(pos, entity.getId()));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.WALL_LANTERN_TILE.get(), (BlockEntityTicker)(pLevel.isClientSide ? SwayingBlockTile::clientTick : null));
    }

    public void placeOn(BlockState lantern, BlockPos onPos, Direction face, Level world) {
        BlockState state = (BlockState)WallLanternBlock.getConnectedState(this.defaultBlockState(), world.getBlockState(onPos), (LevelAccessor)world, onPos, face).setValue((Property)FACING, (Comparable)face);
        BlockPos newPos = onPos.relative(face);
        world.setBlock(newPos, state, 3);
        BlockEntity blockEntity = world.getBlockEntity(newPos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            tile.setHeldBlock(lantern);
        }
    }

    public static boolean isValidBlock(@NotNull Block b) {
        if (b.asItem() == Items.AIR) {
            return false;
        }
        ResourceLocation id = Utils.getID((Block)b);
        String namespace = id.getNamespace();
        if (CommonConfigs.WALL_LANTERN_WHITELIST.get().contains(id.toString())) {
            return true;
        }
        if (CommonConfigs.WALL_LANTERN_BLACKLIST.get().contains(namespace)) {
            return false;
        }
        if (namespace.equals("skinnedlanterns") || namespace.equals("twigs") && id.getPath().contains("paper_lantern")) {
            return true;
        }
        if (b instanceof LanternBlock) {
            return !b.defaultBlockState().hasBlockEntity() || CompatHandler.SUPPSQUARED && SuppSquaredCompat.isLightableLantern(b);
        }
        return false;
    }
}

