/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.gui;

import java.util.Arrays;
import java.util.Locale;
import net.mehvahdjukaar.amendments.Amendments;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class QuillButton
extends AbstractWidget {
    protected static final ResourceLocation[] textures = (ResourceLocation[])Arrays.stream(QuillType.values()).map(t -> Amendments.res("textures/gui/quill/" + t.name().toLowerCase(Locale.ROOT) + ".png")).toArray(ResourceLocation[]::new);
    private int type = 0;

    public QuillButton(Screen screen) {
        super(screen.width / 2 + 70, 20, 48, 144, (Component)Component.empty());
        this.refreshTooltip();
    }

    private void refreshTooltip() {
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)("gui.amendments.quill." + this.getType().name().toLowerCase(Locale.ROOT)))));
    }

    public QuillType getType() {
        return QuillType.values()[this.type];
    }

    public void onClick(double mouseX, double mouseY) {
        int length = QuillType.values().length;
        this.type = Screen.hasShiftDown() ? (length + this.type - 1) % length : (this.type + 1) % length;
        this.refreshTooltip();
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.type += button == 0 ? 1 : -1;
        this.type %= QuillType.values().length;
        this.refreshTooltip();
    }

    protected boolean isValidClickButton(int button) {
        return super.isValidClickButton(button) || button == 1;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.blit(textures[this.type], this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public ChatFormatting getChatFormatting() {
        return switch (this.getType().ordinal()) {
            case 2 -> ChatFormatting.BOLD;
            case 4 -> ChatFormatting.STRIKETHROUGH;
            case 1 -> ChatFormatting.ITALIC;
            case 3 -> ChatFormatting.UNDERLINE;
            case 5 -> ChatFormatting.OBFUSCATED;
            default -> ChatFormatting.RESET;
        };
    }

    public static enum QuillType {
        DEFAULT,
        ITALIC,
        BOLD,
        UNDERLINE,
        STRIKETHROUGH,
        OBFUSCATED;

    }
}

