/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betteroceanmonuments.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.UnderwaterMagmaFeature;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={UnderwaterMagmaFeature.class})
public class NoMagmaInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void betteroceanmonuments_noMagmaInStructures(FeaturePlaceContext<DeltaFeatureConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        if (!(context.level() instanceof WorldGenRegion)) {
            return;
        }
        SectionPos sectionPos = SectionPos.of((BlockPos)context.origin());
        if (context.level().getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES, false) == null) {
            return;
        }
        Registry configuredStructureFeatureRegistry = context.level().registryAccess().registryOrThrow(Registries.STRUCTURE);
        StructureManager structureManager = context.level().getLevel().structureManager();
        Structure monumentStructure = (Structure)configuredStructureFeatureRegistry.get(ResourceLocation.fromNamespaceAndPath((String)"betteroceanmonuments", (String)"ocean_monument"));
        if (monumentStructure == null) {
            return;
        }
        if (structureManager.getStructureAt(context.origin(), monumentStructure).isValid()) {
            cir.setReturnValue((Object)false);
        }
    }
}

