/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlimeTrailParticle
extends TextureSheetParticle {
    private final int rotation;
    private final BlockPos pos;

    protected SlimeTrailParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.pickSprite(sprites);
        this.quadSize = 0.5f * scale;
        this.setSize(this.quadSize + 1.0f, 0.1f);
        this.lifetime = (int)Math.min(300.0f + 200.0f * scale, 1200.0f);
        this.rotation = this.random.nextInt(3);
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        if (!this.level.getBlockState(this.pos).isAir() || this.level.getBlockState(this.pos.below()).isAir()) {
            this.remove();
            return;
        }
        if (this.age >= this.lifetime / 2) {
            this.alpha = Mth.clamp((float)(this.alpha - 0.015f), (float)0.0f, (float)1.0f);
            if (this.alpha == 0.0f) {
                this.remove();
            }
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        Vec3 pos = camera.getPosition();
        double x = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - pos.x();
        double y = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - pos.y();
        double z = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - pos.z();
        Vec3[] vec3s = new Vec3[]{new Vec3(-1.0, -1.0, 0.0), new Vec3(-1.0, 1.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, -1.0, 0.0)};
        for (int i = 0; i < vec3s.length; ++i) {
            vec3s[i] = vec3s[i].xRot(SlimeTrailParticle.toRot(-90.0f)).yRot(SlimeTrailParticle.toRot(90 * this.rotation)).scale((double)this.getQuadSize(partialTick)).add(x, y, z);
        }
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int lightColor = this.getLightColor(partialTick);
        consumer.addVertex((float)vec3s[0].x(), (float)vec3s[0].y(), (float)vec3s[0].z()).setUv(maxU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(lightColor);
        consumer.addVertex((float)vec3s[1].x(), (float)vec3s[1].y(), (float)vec3s[1].z()).setUv(maxU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(lightColor);
        consumer.addVertex((float)vec3s[2].x(), (float)vec3s[2].y(), (float)vec3s[2].z()).setUv(minU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(lightColor);
        consumer.addVertex((float)vec3s[3].x(), (float)vec3s[3].y(), (float)vec3s[3].z()).setUv(minU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(lightColor);
    }

    private static float toRot(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        @Nullable
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SlimeTrailParticle(level, this.sprites, x, y, z, Math.min(options.f(), 64.0f));
        }
    }
}

