/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPacket;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandlers {
    public static void handle(ClientLevel level, ClientBoundEntityFellPacket packet) {
        Entity entity = level.getEntity(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, packet.y(), packet.distance(), packet.fallDamage(), livingEntity instanceof Player ? ModConfigs.ENTITIES.dustClouds.playerFell : ModConfigs.ENTITIES.dustClouds.mobFell);
        }
    }

    public static void handle(ClientLevel level, ClientBoundEntitySpawnSprintingDustCloudsPacket packet) {
        Entity entity = level.getEntity(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int ySpeedModifier = 5;
            if (livingEntity instanceof Ravager) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (Level)level, livingEntity.getRandom(), ySpeedModifier);
        }
    }

    public static void handle(ClientLevel level, ClientBoundSpawnSnoreParticlePacket packet) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.addParticle((ParticleOptions)ModParticles.SNORING.get(), packet.x(), packet.y(), packet.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(ClientLevel level, ClientBoundBlockDestroyEffectsPacket packet) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(packet)) {
            BlockPos pos = packet.pos();
            BlockState state = Block.stateById((int)packet.stateId());
            SoundType soundType = state.getSoundType();
            level.addDestroyBlockEffect(pos, state);
            level.playLocalSound(pos, soundType.getBreakSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f, false);
        }
    }

    public static void handle(ClientLevel level, ClientBoundXPBottleEffectsPacket packet) {
        int i;
        BlockPos pos = packet.pos();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)pos);
        RandomSource random = level.getRandom();
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.VANILLA) {
            level.levelEvent(2002, pos, PotionContents.getColor((Holder)Potions.WATER));
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ENTITIES.xpBottleParticlesDensity.get(); ++i) {
                double d = random.nextDouble() * 4.0;
                double d1 = random.nextDouble() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.addParticle((ParticleOptions)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.x + xPower * 0.1, vec3.y + 0.3, vec3.z + zPower * 0.1, xPower, 0.01 + random.nextDouble() * 0.5, zPower);
            }
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.SPLASH_POTION)), vec3.x, vec3.y, vec3.z, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
            }
            level.playLocalSound(pos, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
        }
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPacket packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }
}

