/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ParticleEngine.class})
public class ParticleEngineMixin {
    @Shadow
    protected ClientLevel level;

    @Inject(method={"createParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleEngine;add(Lnet/minecraft/client/particle/Particle;)V")})
    private void modifyColor(ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, CallbackInfoReturnable<Particle> cir, @Local Particle particle) {
        if (Util.isBCWPPackLoaded() && Util.BIOME_COLORED_PARTICLES.contains(options.getType())) {
            Util.setColorFromHex(particle, ((Biome)this.level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor());
        }
    }

    @WrapWithCondition(method={"render*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/Particle;render(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;F)V")})
    private boolean shouldRenderParticle(Particle particle, VertexConsumer consumer, Camera camera, float partialTick) {
        Frustum frustum = ((FrustumGetter)Minecraft.getInstance().levelRenderer).subtleEffects$getCullingFrustum();
        if (frustum != null && frustum.isVisible(particle.getBoundingBox())) {
            ParticleAccessor accessor = (ParticleAccessor)particle;
            if (ModConfigs.GENERAL.cullParticlesInUnloadedChunks && !Util.isChunkLoaded((Level)this.level, accessor.getX(), accessor.getZ())) {
                return false;
            }
            if (!ModConfigs.GENERAL.cullParticlesWithNoAlpha || accessor.getAlpha() != 0.0f) {
                int distance = ModConfigs.GENERAL.particleRenderDistance * 16;
                return accessor.subtleEffects$wasForced() || camera.getPosition().distanceToSqr(accessor.getX(), accessor.getY(), accessor.getZ()) < (double)(distance * distance);
            }
        }
        return false;
    }
}

