/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.biome_particles;

import einstein.subtle_effects.biome_particles.BiomeParticleSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class BiomeParticleManager {
    private static final List<BiomeParticleSettings> REGISTERED = new ArrayList<BiomeParticleSettings>();
    private static final BlockPos.MutableBlockPos BIOME_POS = new BlockPos.MutableBlockPos();
    private static final BiPredicate<Level, BlockPos> NOT_RAINING = (level, pos) -> !level.isRaining();
    public static final BiPredicate<Level, BlockPos> FIREFLY_CONDITIONS = NOT_RAINING.and((level, pos) -> {
        float time = (float)level.getDayTime() % 24000.0f;
        return time > 13000.0f && time < 23000.0f && level.getBrightness(LightLayer.BLOCK, pos) <= 5 && ((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos);
    });
    private static boolean HAS_CLEARED;

    public static void init() {
        BiomeParticleManager.register(ModConfigs.BIOMES.mushroomSporeBiomes, ModConfigs.BIOMES.mushroomSporeDensity, 40, ModParticles.MUSHROOM_SPORE, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.BIOMES.fireflyBiomes, ModConfigs.BIOMES.fireflyDensity, 10, ModParticles.FIREFLY, FIREFLY_CONDITIONS);
        BiomeParticleManager.register(ModConfigs.BIOMES.pollenBiomes, ModConfigs.BIOMES.pollenDensity, 10, ModParticles.POLLEN, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.BIOMES.sculkDustBiomes, ModConfigs.BIOMES.sculkDustDensity, ModParticles.SCULK_DUST, (level, pos) -> true);
    }

    private static void register(ValidatedList<ResourceLocation> biomesConfig, int density, int maxSpawnHeight, Supplier<? extends ParticleOptions> particle, BiPredicate<Level, BlockPos> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, maxSpawnHeight, particle, spawnConditions, false));
    }

    private static void register(ValidatedList<ResourceLocation> biomesConfig, int density, Supplier<? extends ParticleOptions> particle, BiPredicate<Level, BlockPos> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, 0, particle, spawnConditions, true));
    }

    public static void tickBiomeParticles(Level level, Player player) {
        int radius;
        if (HAS_CLEARED) {
            HAS_CLEARED = false;
            REGISTERED.forEach(settings -> settings.update(level));
        }
        if ((radius = ModConfigs.BIOMES.biomeParticlesRadius) <= 0) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            RandomSource random = level.getRandom();
            int x = player.getBlockX() + random.nextInt(radius) - random.nextInt(radius);
            int y = player.getBlockY() + random.nextInt(radius) - random.nextInt(radius);
            int z = player.getBlockZ() + random.nextInt(radius) - random.nextInt(radius);
            BIOME_POS.set(x, y, z);
            if (level.isOutsideBuildHeight(y)) continue;
            Holder biome = level.getBiome((BlockPos)BIOME_POS);
            for (BiomeParticleSettings settings2 : REGISTERED) {
                BlockState state;
                int surfaceLevel;
                List<Biome> biomes;
                if (settings2.getDensity() <= i || !settings2.checkSpawnConditions(level, (BlockPos)BIOME_POS) || (biomes = settings2.getBiomes()).isEmpty() || !settings2.ignoreHeight() && ((surfaceLevel = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z)) > y || surfaceLevel + settings2.getMaxSpawnHeight() < y) || !biomes.contains(biome.value()) || (state = level.getBlockState((BlockPos)BIOME_POS)).isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)BIOME_POS)) continue;
                level.addParticle(settings2.getParticle().get(), (double)x + random.nextDouble(), (double)y + random.nextDouble(), (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void clear() {
        REGISTERED.forEach(BiomeParticleSettings::clear);
        HAS_CLEARED = true;
    }
}

