/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simplylightsources.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeCappedCagedCubeLightBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = FaceAttachedHorizontalDirectionalBlock.FACE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public LargeCappedCagedCubeLightBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.LANTERN).strength(3.5f).lightLevel(s -> 15).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)1.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)3.5, (double)0.0, (double)12.5, (double)12.5, (double)1.0), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)3.5, (double)9.0, (double)12.5, (double)12.5, (double)10.0)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)15.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)6.0, (double)3.5, (double)12.5, (double)7.0, (double)12.5)});
            }
            case Direction.NORTH -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)1.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)4.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)3.5, (double)15.0, (double)12.5, (double)12.5, (double)16.0), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)3.5, (double)6.0, (double)12.5, (double)12.5, (double)7.0)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)15.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)6.0, (double)3.5, (double)12.5, (double)7.0, (double)12.5)});
            }
            case Direction.EAST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)1.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)1.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)0.0, (double)3.5, (double)3.5, (double)1.0, (double)12.5, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)9.0, (double)3.5, (double)3.5, (double)10.0, (double)12.5, (double)12.5)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)15.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)6.0, (double)3.5, (double)12.5, (double)7.0, (double)12.5)});
            }
            case Direction.WEST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)1.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)7.0, (double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)15.0, (double)3.5, (double)3.5, (double)16.0, (double)12.5, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)6.0, (double)3.5, (double)3.5, (double)7.0, (double)12.5, (double)12.5)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LargeCappedCagedCubeLightBlock.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LargeCappedCagedCubeLightBlock.box((double)3.5, (double)15.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5), LargeCappedCagedCubeLightBlock.box((double)3.5, (double)6.0, (double)3.5, (double)12.5, (double)7.0, (double)12.5)});
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FACE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag;
        boolean bl = flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACE, (Comparable)(context.getClickedFace().getOpposite() == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

