/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.leclowndu93150.particlerain.particle.render.GroundFogRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;

public class GroundFogParticle
extends WeatherParticle {
    float xdxd;
    float zdzd;

    private GroundFogParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        ++ParticleRainClient.fogCount;
        this.setSprite(provider.get(level.getRandom()));
        this.quadSize = ParticleRainConfig.GroundFogOptions.size;
        this.lifetime = 30000;
        Color color = new Color(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getFogColor());
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
        this.oRoll = this.roll = 1.5707964f * (float)level.random.nextInt(4);
        this.xdxd = (this.random.nextFloat() - 0.5f) / 100.0f;
        this.zdzd = (this.random.nextFloat() - 0.5f) / 100.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.onGround) {
            this.remove();
        }
        this.xd = this.xdxd;
        this.zd = this.zdzd;
    }

    @Override
    public void remove() {
        if (this.isAlive()) {
            --ParticleRainClient.fogCount;
        }
        super.remove();
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return this.getBoundingBox().inflate(4.0);
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
        quaternion.rotateZ(Mth.lerp((float)f, (float)this.oRoll, (float)this.roll));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, f);
    }

    public ParticleRenderType getRenderType() {
        return GroundFogRenderType.INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new GroundFogParticle(level, x, y, z, this.provider);
        }
    }
}

