/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.mixin;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;
    @Unique
    List<SpriteContents> spriteContentsList;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    public void stitch(List<SpriteContents> list, int i, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        this.spriteContentsList = list;
    }

    @ModifyExpressionValue(method={"stitch"}, at={@At(value="NEW", args={"class=net/minecraft/client/renderer/texture/Stitcher"})})
    private Stitcher<SpriteContents> registerWeatherParticles(Stitcher<SpriteContents> stitcher) {
        if (this.location.equals((Object)ResourceLocation.withDefaultNamespace((String)"textures/atlas/particles.png"))) {
            int i;
            int i2;
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
            NativeImage rainImage = null;
            NativeImage snowImage = null;
            try {
                rainImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)"textures/environment/rain.png"));
                snowImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)"textures/environment/snow.png"));
                if (ParticleRainConfig.biomeTint) {
                    rainImage.applyToAllPixels(ParticleRainClient.desaturateOperation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)ParticleRainClient.splitImage(rainImage, i2, "rain"));
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)ParticleRainClient.splitImage(snowImage, i2, "snow"));
            }
            int rippleResolution = ParticleRainClient.getRippleResolution(this.spriteContentsList);
            for (i = 0; i < 8; ++i) {
                stitcher.registerSprite((Stitcher.Entry)ParticleRainClient.generateRipple(i, rippleResolution));
            }
            if (ParticleRainConfig.biomeTint) {
                for (i = 0; i < 4; ++i) {
                    NativeImage splashImage = null;
                    try {
                        splashImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)("textures/particle/splash_" + i + ".png")));
                        splashImage.applyToAllPixels(ParticleRainClient.desaturateOperation);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    stitcher.registerSprite((Stitcher.Entry)new SpriteContents(ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)("splash" + i)), new FrameSize(splashImage.getWidth(), splashImage.getHeight()), splashImage, new ResourceMetadata.Builder().build()));
                }
            }
        }
        return stitcher;
    }
}

