/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.mixin;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.WeatherParticleSpawner;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int ticks;
    @Shadow
    private int rainSoundTime;

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRain(Camera camera, CallbackInfo ci) {
        if (!ParticleRainConfig.tickVanillaWeather) {
            float f = this.minecraft.level.getRainLevel(1.0f);
            if (f > 0.0f) {
                Random random = new Random((long)this.ticks * 312987231L);
                ClientLevel level = this.minecraft.level;
                BlockPos blockPos = BlockPos.containing((Position)camera.getPosition());
                BlockPos blockPos2 = null;
                int j = 0;
                while ((float)j < 100.0f * f * f) {
                    int l;
                    int k = random.nextInt(21) - 10;
                    BlockPos blockPos3 = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos.offset(k, 0, l = random.nextInt(21) - 10));
                    if (blockPos3.getY() > level.getMinBuildHeight() && blockPos3.getY() <= blockPos.getY() + 10 && blockPos3.getY() >= blockPos.getY() - 10) {
                        blockPos2 = blockPos3.below();
                    }
                    ++j;
                }
                if (blockPos2 != null && random.nextInt(3) < this.rainSoundTime++) {
                    this.rainSoundTime = 0;
                    if (blockPos2.getY() > blockPos.getY() + 1 && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > Mth.floor((float)blockPos.getY())) {
                        SoundEvent sound = WeatherParticleSpawner.getBiomeSound(blockPos2, true);
                        if (sound != null) {
                            this.minecraft.level.playLocalSound(blockPos2, sound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        }
                    } else {
                        SoundEvent sound = WeatherParticleSpawner.getBiomeSound(blockPos2, false);
                        if (sound != null) {
                            this.minecraft.level.playLocalSound(blockPos2, sound, SoundSource.WEATHER, 0.2f, 1.0f, false);
                        }
                    }
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderWeather(LightTexture lightTexture, float partialTicks, double x, double y, double z, CallbackInfo ci) {
        if (!ParticleRainConfig.renderVanillaWeather) {
            ci.cancel();
        }
    }
}

