/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.network.BasePacket;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public record DoSlotDraggingPacket(int containerId, int slotId, boolean isItem, @Nullable ItemVariant itemVariant, @Nullable FluidVariant fluidVariant) implements BasePacket
{
    public static StreamCodec<RegistryFriendlyByteBuf, DoSlotDraggingPacket> STREAM_CODEC = StreamCodec.ofMember(DoSlotDraggingPacket::write, DoSlotDraggingPacket::new);

    public DoSlotDraggingPacket(int containerId, int slotId, ItemVariant itemVariant) {
        this(containerId, slotId, true, itemVariant, null);
    }

    public DoSlotDraggingPacket(int containerId, int slotId, FluidVariant fluidVariant) {
        this(containerId, slotId, false, null, fluidVariant);
    }

    private DoSlotDraggingPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readVarInt(), buf.readBoolean(), buf);
    }

    private DoSlotDraggingPacket(int containerId, int slotId, boolean isItem, RegistryFriendlyByteBuf buf) {
        this(containerId, slotId, isItem, isItem ? ItemVariant.fromPacket(buf) : null, isItem ? null : FluidVariant.fromPacket(buf));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeVarInt(this.slotId);
        buf.writeBoolean(this.isItem);
        if (this.isItem) {
            this.itemVariant.toPacket(buf);
        } else {
            this.fluidVariant.toPacket(buf);
        }
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnServer();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.containerId) {
            Slot slot = sh.getSlot(this.slotId);
            ReiDraggable dw = (ReiDraggable)slot;
            if (this.isItem) {
                dw.dragItem(this.itemVariant, Simulation.ACT);
            } else {
                dw.dragFluid(this.fluidVariant, Simulation.ACT);
            }
        }
    }
}

