/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import java.util.Collections;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ElectricWaterPumpBlockEntity
extends AbstractWaterPumpBlockEntity
implements EnergyComponentHolder,
CableTierHolder {
    private final MIInventory inventory;
    private final RedstoneControlComponent redstoneControl;
    private final CasingComponent casing;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;

    public ElectricWaterPumpBlockEntity(BEP bep) {
        super(bep, "electric_water_pump");
        long capacity = 32000L;
        this.inventory = new MIInventory(Collections.emptyList(), Collections.singletonList(ConfigurableFluidStack.lockedOutputSlot(capacity, (Fluid)Fluids.WATER)), SlotPositions.empty(), new SlotPositions.Builder().addSlot(110, 30).build());
        this.redstoneControl = new RedstoneControlComponent();
        this.casing = new CasingComponent();
        this.energy = new EnergyComponent((BlockEntity)this, this.casing::getEuCapacity);
        this.insertable = this.energy.buildInsertable(this.casing::canInsertEu);
        this.registerComponents(this.inventory, this.redstoneControl, this.casing, this.energy);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(18, 32), this.energy::getEu, this.energy::getCapacity);
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl).withCasing(this.casing));
    }

    @Override
    protected long consumeEu(long max) {
        if (this.redstoneControl.doAllowNormalOperation(this)) {
            return this.energy.consumeEu(max, Simulation.ACT);
        }
        return 0L;
    }

    @Override
    protected int getWaterMultiplier() {
        return 16;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricWaterPumpBlockEntity)be).insertable));
    }

    @Override
    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse(this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse(this, player, hand);
        }
        return result;
    }

    @Override
    public CableTier getCableTier() {
        return this.casing.getCableTier();
    }
}

