/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.common.NeoForgeMod;

public class QuantumArmorItem
extends ArmorItem {
    public QuantumArmorItem(ArmorItem.Type type, Item.Properties settings) {
        super(MIArmorMaterials.QUANTUM, type, settings.stacksTo(1).attributes(QuantumArmorItem.buildModifiers(type)));
    }

    private static ItemAttributeModifiers buildModifiers(ArmorItem.Type type) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(MIRegistries.QUANTUM_ARMOR, new AttributeModifier(MI.id("quantum_armor_%s".formatted(type.getName())), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(NeoForgeMod.CREATIVE_FLIGHT, new AttributeModifier(MI.id("quantum_flight"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
        }
        return builder.build();
    }
}

