/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class DyeRecipesProvider
extends MIRecipesProvider {
    public DyeRecipesProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public void buildRecipes(RecipeOutput consumer) {
        for (DyeColor color : DyeColor.values()) {
            String pathPrefix = "dyes/" + color.getName() + "/";
            String dyeTag = "#" + String.valueOf(color.getTag().location());
            ShapedRecipeJson itemPipesDirect = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_item_pipe", 16, "CCC", "GdG", "CCC").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('G', "#c:gears/steel").addInput('d', dyeTag);
            itemPipesDirect.offerTo(consumer, pathPrefix + "craft/item_pipe_direct");
            itemPipesDirect.exportToAssembler().offerTo(consumer, pathPrefix + "assembler/item_pipe_direct");
            ShapedRecipeJson eightItemPipes = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_item_pipe", 8, "ppp", "pdp", "ppp").addInput('d', dyeTag).addInput('p', "#modern_industrialization:item_pipes");
            eightItemPipes.offerTo(consumer, pathPrefix + "craft/item_pipe_8");
            eightItemPipes.exportToMachine(MIMachineRecipeTypes.MIXER, 2, 100, 1).offerTo(consumer, pathPrefix + "mixer/item_pipe_8");
            new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_item_pipe", 1, "pd").addInput('d', dyeTag).addInput('p', "#modern_industrialization:item_pipes").offerTo(consumer, pathPrefix + "craft/item_pipe_1");
            ShapedRecipeJson fluidPipesStainedGlass = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_fluid_pipe", 16, "CCC", "rPr", "CCC").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('r', "modern_industrialization:copper_rotor").addInput('P', color.getName() + "_stained_glass_pane");
            fluidPipesStainedGlass.offerTo(consumer, pathPrefix + "craft/fluid_pipe_stained_glass");
            fluidPipesStainedGlass.exportToAssembler().offerTo(consumer, pathPrefix + "assembler/fluid_pipe_stained_glass");
            ShapedRecipeJson eightFluidPipes = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_fluid_pipe", 8, "ppp", "pdp", "ppp").addInput('d', dyeTag).addInput('p', "#modern_industrialization:fluid_pipes");
            eightFluidPipes.offerTo(consumer, pathPrefix + "craft/fluid_pipe_8");
            eightFluidPipes.exportToMachine(MIMachineRecipeTypes.MIXER, 2, 100, 1).offerTo(consumer, pathPrefix + "mixer/fluid_pipe_8");
            new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_fluid_pipe", 1, "pd").addInput('d', dyeTag).addInput('p', "#modern_industrialization:fluid_pipes").offerTo(consumer, pathPrefix + "craft/fluid_pipe_1");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 200).addFluidInput(MIFluids.SYNTHETIC_OIL, 100)).addItemInput(dyeTag, 1, 0.0f)).addItemOutput("minecraft:" + color.getName() + "_dye", 1)).offerTo(consumer, pathPrefix + "mixer/synthetic_oil");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 200).addFluidInput(MIFluids.BENZENE, 25)).addItemInput(dyeTag, 1, 0.0f)).addItemOutput("minecraft:" + color.getName() + "_dye", 1)).offerTo(consumer, pathPrefix + "mixer/benzene");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#minecraft:wool", 8)).addItemOutput("minecraft:" + color.getName() + "_wool", 8)).offerTo(consumer, pathPrefix + "mixer/wool");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#c:glass_blocks", 8)).addItemOutput("minecraft:" + color.getName() + "_stained_glass", 8)).offerTo(consumer, pathPrefix + "mixer/glass");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#c:glass_panes", 8)).addItemOutput("minecraft:" + color.getName() + "_stained_glass_pane", 8)).offerTo(consumer, pathPrefix + "mixer/glass_pane");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#c:shulker_boxes", 1)).addItemOutput("minecraft:" + color.getName() + "_shulker_box", 1)).offerTo(consumer, pathPrefix + "mixer/shulker_box");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#minecraft:beds", 1)).addItemOutput("minecraft:" + color.getName() + "_bed", 1)).offerTo(consumer, pathPrefix + "mixer/bed");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#minecraft:candles", 1)).addItemOutput("minecraft:" + color.getName() + "_candle", 1)).offerTo(consumer, pathPrefix + "mixer/candle");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput("#minecraft:wool_carpets", 8)).addItemOutput("minecraft:" + color.getName() + "_carpet", 8)).offerTo(consumer, pathPrefix + "mixer/carpet");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput(dyeTag, 1)).addItemInput((TagKey<Item>)ItemTags.TERRACOTTA, 8)).addItemOutput("minecraft:" + color.getName() + "_terracotta", 8)).offerTo(consumer, pathPrefix + "mixer/terracotta");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.CUTTING_MACHINE, 2, 100).addFluidInput(MIFluids.LUBRICANT, 1)).addItemInput("minecraft:" + color.getName() + "_stained_glass", 6)).addItemOutput("minecraft:" + color.getName() + "_stained_glass_pane", 16)).offerTo(consumer, pathPrefix + "cutting_machine/glass_pane");
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.CUTTING_MACHINE, 2, 100).addFluidInput(MIFluids.LUBRICANT, 1)).addItemInput("minecraft:" + color.getName() + "_wool", 1)).addItemOutput("minecraft:" + color.getName() + "_carpet", 4)).offerTo(consumer, pathPrefix + "cutting_machine/carpet");
        }
    }
}

