/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.registration;

import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import dev.latvian.mods.kubejs.event.KubeEvent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.Fluid;

public class RegisterFluidNeutronInteractionsEventJS
implements KubeEvent {
    public void register(Fluid fluid, double heatConduction, double density, String scatteringString, double thermalAbsorption, double fastAbsorption, double thermalScattering, double fastScattering, Fluid productFluid, long productPerNeutron, double productProbability) {
        NuclearConstant.ScatteringType scatteringType = switch (scatteringString) {
            case "ultra_light" -> NuclearConstant.ScatteringType.ULTRA_LIGHT;
            case "light" -> NuclearConstant.ScatteringType.LIGHT;
            case "medium" -> NuclearConstant.ScatteringType.MEDIUM;
            case "heavy" -> NuclearConstant.ScatteringType.HEAVY;
            default -> throw new IllegalArgumentException("Invalid ScatteringType: " + scatteringString);
        };
        FluidNuclearComponent.register(new FluidNuclearComponent(fluid, heatConduction, density, scatteringType, new IsotopeParams(thermalAbsorption, fastAbsorption, thermalScattering, fastScattering), FluidVariant.of(productFluid), productPerNeutron, productProbability));
    }

    public void remove(Fluid fluid) {
        if (FluidNuclearComponent.get(fluid) == null) {
            throw new IllegalArgumentException("Fluid " + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)fluid)) + " is not a nuclear component!");
        }
        FluidNuclearComponent.remove(fluid);
    }

    public void modify(Fluid fluid, double heatConduction, double density, String scatteringString, double thermalAbsorption, double fastAbsorption, double thermalScattering, double fastScattering, Fluid productFluid, long productPerNeutron, double productProbability) {
        this.remove(fluid);
        this.register(fluid, heatConduction, density, scatteringString, thermalAbsorption, fastAbsorption, thermalScattering, fastScattering, productFluid, productPerNeutron, productProbability);
    }
}

