/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.util.MIExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ResourceStorage<T extends TransferVariant<?>>(T resource, long amount, boolean locked) {
    public static final ResourceStorage<FluidVariant> FLUID_EMPTY = new ResourceStorage<FluidVariant>(FluidVariant.blank(), 0L, false);
    public static final ResourceStorage<ItemVariant> ITEM_EMPTY = new ResourceStorage<ItemVariant>(ItemVariant.blank(), 0L, false);

    public ResourceStorage {
        if (resource.isBlank() && amount != 0L) {
            throw new IllegalArgumentException("Expected 0 amount for blank resoruce, got " + amount);
        }
    }

    public ResourceStorage<T> withResource(T resource) {
        return new ResourceStorage<T>(resource, this.amount, this.locked);
    }

    public ResourceStorage<T> withAmount(long amount) {
        return new ResourceStorage<T>(this.resource, amount, this.locked);
    }

    public ResourceStorage<T> withLocked(boolean locked) {
        return new ResourceStorage<T>(this.resource, this.amount, locked);
    }

    public static <T extends TransferVariant<?>> Codec<ResourceStorage<T>> codec(Codec<T> variantCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)variantCodec.fieldOf("resource").forGetter(ResourceStorage::resource), (App)MIExtraCodecs.POSITIVE_LONG.optionalFieldOf("amount", (Object)0L).forGetter(ResourceStorage::amount), (App)Codec.BOOL.optionalFieldOf("locked", (Object)false).forGetter(ResourceStorage::locked)).apply((Applicative)instance, ResourceStorage::new));
    }

    public static <T extends TransferVariant<?>> StreamCodec<RegistryFriendlyByteBuf, ResourceStorage<T>> streamCodec(StreamCodec<RegistryFriendlyByteBuf, T> variantCodec) {
        return StreamCodec.composite(variantCodec, ResourceStorage::resource, (StreamCodec)ByteBufCodecs.VAR_LONG, ResourceStorage::amount, (StreamCodec)ByteBufCodecs.BOOL, ResourceStorage::locked, (resource, amount, locked) -> {
            if (resource.isBlank()) {
                amount = 0L;
            }
            return new ResourceStorage<TransferVariant>((TransferVariant)resource, (long)amount, (boolean)locked);
        });
    }

    public static <T extends TransferVariant<?>> UnaryOperator<DataComponentType.Builder<ResourceStorage<T>>> component(Codec<T> variantCodec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        return builder -> builder.persistent(ResourceStorage.codec(variantCodec)).networkSynchronized(ResourceStorage.streamCodec(streamCodec));
    }
}

