/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks;

import aztech.modern_industrialization.MICapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TrashCanBlock
extends Block {
    public TrashCanBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pOldState.is((Block)this)) {
            pLevel.invalidateCapabilities(pPos);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock())) {
            pLevel.invalidateCapabilities(pPos);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public static void onRegister(Block block, Item blockItem) {
        MICapabilities.onEvent(event -> {
            event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, direction) -> TrashItemHandler.INSTANCE, new Block[]{block});
            event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> TrashItemHandler.INSTANCE, new ItemLike[]{blockItem});
            event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, be, direction) -> TrashFluidHandler.INSTANCE, new Block[]{block});
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new TrashFluidHandlerItem((ItemStack)stack), new ItemLike[]{blockItem});
        });
    }

    private static class TrashFluidHandlerItem
    extends TrashFluidHandler
    implements IFluidHandlerItem {
        private final ItemStack container;

        private TrashFluidHandlerItem(ItemStack container) {
            this.container = container;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }
    }

    private static class TrashFluidHandler
    implements IFluidHandler {
        private static final TrashFluidHandler INSTANCE = new TrashFluidHandler();

        private TrashFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return resource.getAmount();
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private static class TrashItemHandler
    implements IItemHandler {
        private static final TrashItemHandler INSTANCE = new TrashItemHandler();

        private TrashItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    }
}

