/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.mimicworld.util;

import com.mrbysco.mimicworld.block.MimicPortalBlock;
import com.mrbysco.mimicworld.data.PortalCache;
import com.mrbysco.mimicworld.registry.MimicRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;

public class PortalChecker {
    public static boolean checkPortal(ServerLevel level, BlockPos blockpos) {
        List<BlockPos> centerList = BlockPos.betweenClosedStream((BlockPos)blockpos.above().north().west(), (BlockPos)blockpos.above().south().east()).map(BlockPos::immutable).toList();
        ArrayList<BlockPos> corners = new ArrayList<BlockPos>(BlockPos.betweenClosedStream((BlockPos)blockpos.above().north(2).west(2), (BlockPos)blockpos.above().south(2).east(2)).map(BlockPos::immutable).toList());
        corners.removeAll(centerList);
        boolean airCorrect = true;
        for (BlockPos center : centerList) {
            if (level.getBlockState(center).isAir()) continue;
            airCorrect = false;
            break;
        }
        if (!airCorrect) {
            return false;
        }
        boolean frameCorrect = true;
        for (BlockPos corner : corners) {
            if (level.getBlockState(corner).is(Blocks.SCULK)) continue;
            frameCorrect = false;
            break;
        }
        return frameCorrect;
    }

    public static void activatePortal(ServerLevel level, BlockPos blockpos) {
        List<BlockPos> centerList = BlockPos.betweenClosedStream((BlockPos)blockpos.above().north().west(), (BlockPos)blockpos.above().south().east()).map(BlockPos::immutable).toList();
        for (BlockPos center : centerList) {
            level.setBlock(center, ((MimicPortalBlock)((Object)MimicRegistry.MIMIC_PORTAL.get())).defaultBlockState(), 3);
            level.playSound(null, center, Blocks.NETHER_PORTAL.getSoundType(level.getBlockState(center), (LevelReader)level, center, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        PortalCache.get((Level)level).addPortal(level.dimension().location(), blockpos);
    }

    public static void placePortal(ServerLevel level, BlockPos blockpos) {
        level.setBlock(blockpos, Blocks.SCULK_SHRIEKER.defaultBlockState(), 3);
        List<BlockPos> centerList = BlockPos.betweenClosedStream((BlockPos)blockpos.above().north().west(), (BlockPos)blockpos.above().south().east()).map(BlockPos::immutable).toList();
        for (BlockPos center : centerList) {
            level.removeBlock(center, false);
        }
        ArrayList<BlockPos> corners = new ArrayList<BlockPos>(BlockPos.betweenClosedStream((BlockPos)blockpos.above().north(2).west(2), (BlockPos)blockpos.above().south(2).east(2)).map(BlockPos::immutable).toList());
        corners.removeAll(centerList);
        for (BlockPos corner : corners) {
            level.setBlock(corner, Blocks.SCULK.defaultBlockState(), 3);
        }
        PortalCache.get((Level)level).addPortal(level.dimension().location(), blockpos);
    }
}

