/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.mimicworld.util;

import com.mrbysco.mimicworld.data.PortalCache;
import com.mrbysco.mimicworld.util.PortalChecker;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class MimicTeleporter {
    public static DimensionTransition getPortalInfo(Entity entity, ServerLevel destWorld) {
        PortalCache cache = PortalCache.get((Level)destWorld);
        BlockPos originalPos = entity.blockPosition();
        cache.validateNearestPortals(destWorld, originalPos);
        List<BlockPos> portalList = cache.getPortals(destWorld.dimension().location()).stream().filter(pos -> pos.distManhattan((Vec3i)originalPos) < 16).toList();
        if (portalList.isEmpty()) {
            PortalChecker.placePortal(destWorld, entity.blockPosition().below());
        }
        for (BlockPos.MutableBlockPos checkPos : BlockPos.spiralAround((BlockPos)originalPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            destWorld.getChunk((BlockPos)checkPos);
            if (!destWorld.getBlockState(checkPos.immutable().relative(Direction.DOWN)).isSolid() || !MimicTeleporter.isPositionSafe(entity, destWorld, (BlockPos)checkPos, destWorld.getMinBuildHeight())) continue;
            return new DimensionTransition(destWorld, new Vec3((double)checkPos.getX() + 0.5, (double)checkPos.getY(), (double)checkPos.getZ() + 0.5), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
        }
        return new DimensionTransition(destWorld, entity.position(), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
    }

    private static boolean isPositionSafe(Entity entity, ServerLevel destWorld, BlockPos checkPos, int getMinBuildHeight) {
        float halfWidth = entity.getBbWidth() / 2.0f;
        Iterator iterator = BlockPos.betweenClosed((int)Math.round((float)checkPos.getX() - halfWidth), (int)checkPos.getY(), (int)Math.round((float)checkPos.getZ() - halfWidth), (int)Math.round((float)checkPos.getX() + halfWidth), (int)Math.round((float)checkPos.getY() + entity.getBbHeight()), (int)Math.round((float)checkPos.getZ() + halfWidth)).iterator();
        if (iterator.hasNext()) {
            BlockPos entityBoxPos = (BlockPos)iterator.next();
            if (!destWorld.getWorldBorder().isWithinBounds(entityBoxPos)) {
                return false;
            }
            BlockState entityBoxState = destWorld.getBlockState(entityBoxPos);
            return entityBoxState.getBlock().isPossibleToRespawnInThis(entityBoxState);
        }
        return true;
    }
}

