/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.mimicworld.handler;

import com.mrbysco.mimicworld.data.PortalCache;
import com.mrbysco.mimicworld.registry.MimicRegistry;
import com.mrbysco.mimicworld.util.PortalChecker;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class PortalHandler {
    @SubscribeEvent
    public void onGameEvent(VanillaGameEvent event) {
        boolean validPortal;
        BlockPos pos;
        ServerLevel serverLevel;
        BlockState blockstate;
        Level level;
        if (event.getVanillaEvent() == GameEvent.SHRIEK && (level = event.getLevel()) instanceof ServerLevel && (blockstate = (serverLevel = (ServerLevel)level).getBlockState(pos = BlockPos.containing((Position)event.getEventPosition()))).is(Blocks.SCULK_SHRIEKER) && !((Boolean)blockstate.getValue((Property)SculkShriekerBlock.CAN_SUMMON)).booleanValue() && (validPortal = PortalChecker.checkPortal(serverLevel, pos))) {
            PortalChecker.activatePortal(serverLevel, pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        List<BlockPos> centerList;
        LevelAccessor level = event.getLevel();
        BlockPos blockpos = event.getPos();
        if (level.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (event.getState().is(Blocks.SCULK_SHRIEKER) && level.getBlockState(blockpos.above()).is((Block)MimicRegistry.MIMIC_PORTAL.get())) {
            centerList = BlockPos.betweenClosedStream((BlockPos)blockpos.above().north().west(), (BlockPos)blockpos.above().south().east()).map(BlockPos::immutable).toList();
            for (BlockPos center : centerList) {
                if (!level.getBlockState(center).is((Block)MimicRegistry.MIMIC_PORTAL.get())) continue;
                level.removeBlock(center, false);
            }
            PortalCache.get((Level)serverLevel).removePortal(serverLevel.dimension().location(), blockpos);
        }
        if (event.getState().is(Blocks.SCULK) || event.getState().is((Block)MimicRegistry.MIMIC_PORTAL.get())) {
            centerList = BlockPos.betweenClosedStream((BlockPos)blockpos.north().west(), (BlockPos)blockpos.south().east()).map(BlockPos::immutable).toList();
            boolean partOfPortal = false;
            for (BlockPos center : centerList) {
                if (!level.getBlockState(center).is((Block)MimicRegistry.MIMIC_PORTAL.get())) continue;
                partOfPortal = true;
                break;
            }
            if (partOfPortal) {
                List<BlockPos> corners = BlockPos.betweenClosedStream((BlockPos)blockpos.north(4).west(4), (BlockPos)blockpos.south(4).east(4)).map(BlockPos::immutable).toList();
                for (BlockPos corner : corners) {
                    if (!level.getBlockState(corner).is((Block)MimicRegistry.MIMIC_PORTAL.get())) continue;
                    level.playSound(null, corner, Blocks.NETHER_PORTAL.getSoundType(level.getBlockState(corner), (LevelReader)level, corner, null).getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.removeBlock(corner, false);
                }
                PortalCache.get((Level)serverLevel).removeNearestPortal(serverLevel.dimension().location(), blockpos.below());
            }
        }
    }
}

