/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.mimicworld.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PortalCache
extends SavedData {
    private static final String DATA_NAME = "mimicworld_portal_data";
    private final ListMultimap<ResourceLocation, BlockPos> paintingPositionMap = ArrayListMultimap.create();

    public PortalCache(ListMultimap<ResourceLocation, BlockPos> paintingMap) {
        this.paintingPositionMap.clear();
        if (!paintingMap.isEmpty()) {
            this.paintingPositionMap.putAll(paintingMap);
        }
    }

    public PortalCache() {
        this((ListMultimap<ResourceLocation, BlockPos>)ArrayListMultimap.create());
    }

    public static PortalCache load(CompoundTag tag, HolderLookup.Provider registries) {
        ArrayListMultimap paintingMap = ArrayListMultimap.create();
        for (String nbtName : tag.getAllKeys()) {
            Tag nbt;
            ListTag dimensionNBTList = new ListTag();
            if (tag.getTagType(nbtName) == 9 && (nbt = tag.get(nbtName)) instanceof ListTag) {
                ListTag listNBT = (ListTag)nbt;
                if (!listNBT.isEmpty() && listNBT.getElementType() != 10) continue;
                dimensionNBTList = listNBT;
            }
            if (dimensionNBTList.isEmpty()) continue;
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            for (int i = 0; i < dimensionNBTList.size(); ++i) {
                CompoundTag dimTag = dimensionNBTList.getCompound(i);
                if (!dimTag.contains("BlockPos")) continue;
                BlockPos blockPos = BlockPos.of((long)dimTag.getLong("BlockPos"));
                posList.add(blockPos);
            }
            paintingMap.putAll((Object)ResourceLocation.tryParse((String)nbtName), posList);
        }
        return new PortalCache((ListMultimap<ResourceLocation, BlockPos>)paintingMap);
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        for (ResourceLocation dimensionLocation : this.paintingPositionMap.keySet()) {
            List globalPosList = this.paintingPositionMap.get((Object)dimensionLocation);
            ListTag dimensionStorage = new ListTag();
            for (BlockPos portalLoc : globalPosList) {
                CompoundTag positionTag = new CompoundTag();
                positionTag.putLong("BlockPos", portalLoc.asLong());
                dimensionStorage.add((Object)positionTag);
            }
            compound.put(dimensionLocation.toString(), (Tag)dimensionStorage);
        }
        return compound;
    }

    public List<BlockPos> getPortals(ResourceLocation dimensionLocation) {
        return this.paintingPositionMap.get((Object)dimensionLocation);
    }

    public void validateNearestPortals(ServerLevel destWorld, BlockPos nearestPos) {
        ResourceLocation dimensionLocation = destWorld.dimension().location();
        List<BlockPos> portalList = this.getPortals(dimensionLocation);
        for (BlockPos pos : portalList) {
            if (pos.distManhattan((Vec3i)nearestPos) >= 16) continue;
            destWorld.getChunk(pos);
            if (destWorld.getBlockState(pos).is(Blocks.SCULK_SHRIEKER)) continue;
            portalList.remove(pos);
        }
        this.setDirty();
    }

    public void addPortal(ResourceLocation dimensionLocation, BlockPos pos) {
        List<BlockPos> nearestPortals = this.paintingPositionMap.get((Object)dimensionLocation).stream().filter(loc -> loc.distManhattan((Vec3i)pos) < 5).toList();
        if (nearestPortals.isEmpty()) {
            this.paintingPositionMap.get((Object)dimensionLocation).add(pos);
        }
        this.setDirty();
    }

    public void removePortal(ResourceLocation dimensionLocation, BlockPos pos) {
        this.paintingPositionMap.get((Object)dimensionLocation).removeIf(loc -> loc.distManhattan((Vec3i)pos) < 3);
        this.setDirty();
    }

    public void removeNearestPortal(ResourceLocation dimensionLocation, BlockPos pos) {
        BlockPos blockpos = pos.below();
        this.paintingPositionMap.get((Object)dimensionLocation).removeIf(loc -> loc.distManhattan((Vec3i)blockpos) < 5);
        this.setDirty();
    }

    public static PortalCache get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = world.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (PortalCache)storage.computeIfAbsent(new SavedData.Factory(PortalCache::new, PortalCache::load), DATA_NAME);
    }
}

