/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.mimicworld.block;

import com.mrbysco.mimicworld.MimicWorldMod;
import com.mrbysco.mimicworld.util.MimicTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MimicPortalBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public MimicPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel && Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()))), (VoxelShape)state.getShape((BlockGetter)level, pos), (BooleanOp)BooleanOp.AND)) {
            ResourceKey<Level> resourcekey = level.dimension() == MimicWorldMod.MIMIC_WORLD_KEY ? Level.OVERWORLD : MimicWorldMod.MIMIC_WORLD_KEY;
            ServerLevel serverLevel = ((ServerLevel)level).getServer().getLevel(resourcekey);
            if (serverLevel == null) {
                return;
            }
            if (!entity.canChangeDimensions(level, (Level)serverLevel)) {
                return;
            }
            CompoundTag persistentData = entity.getPersistentData();
            if (!persistentData.contains("MimicWorldPortalCooldown")) {
                persistentData.putLong("MimicWorldPortalCooldown", level.getGameTime());
                entity.changeDimension(MimicTeleporter.getPortalInfo(entity, serverLevel));
            } else {
                long cooldown = persistentData.getLong("MimicWorldPortalCooldown");
                if (level.getGameTime() - cooldown > 80L) {
                    persistentData.remove("MimicWorldPortalCooldown");
                }
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        double d0 = (double)pos.getX() + randomSource.nextDouble();
        double d1 = (double)pos.getY() + 0.8;
        double d2 = (double)pos.getZ() + randomSource.nextDouble();
        level.addParticle((ParticleOptions)ParticleTypes.WARPED_SPORE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return false;
    }
}

