/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import snownee.kiwi.RenderLayerEnum;

public class CustomizationCodecs {
    public static final BiMap<ResourceLocation, SoundType> SOUND_TYPES = HashBiMap.create();
    public static final Codec<SoundType> SOUND_TYPE_CODEC = CustomizationCodecs.simpleByNameCodec(SOUND_TYPES);
    public static final BiMap<String, NoteBlockInstrument> INSTRUMENTS = HashBiMap.create();
    public static final Codec<NoteBlockInstrument> INSTRUMENT_CODEC = CustomizationCodecs.simpleByNameCodec(INSTRUMENTS);
    public static final BiMap<String, MapColor> MAP_COLORS = HashBiMap.create();
    public static final Codec<MapColor> MAP_COLOR_CODEC = CustomizationCodecs.simpleByNameCodec(MAP_COLORS);
    public static final Codec<PushReaction> PUSH_REACTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"normal", (Object)PushReaction.NORMAL, (Object)"destroy", (Object)PushReaction.DESTROY, (Object)"block", (Object)PushReaction.BLOCK, (Object)"ignore", (Object)PushReaction.IGNORE, (Object)"push_only", (Object)PushReaction.PUSH_ONLY));
    public static final Codec<RenderLayerEnum> RENDER_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"cutout", (Object)((Object)RenderLayerEnum.CUTOUT), (Object)"cutout_mipped", (Object)((Object)RenderLayerEnum.CUTOUT_MIPPED), (Object)"translucent", (Object)((Object)RenderLayerEnum.TRANSLUCENT)));
    public static final Codec<BlockBehaviour.OffsetType> OFFSET_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"xz", (Object)BlockBehaviour.OffsetType.XZ, (Object)"xyz", (Object)BlockBehaviour.OffsetType.XYZ));
    public static final Codec<BlockBehaviour.StatePredicate> STATE_PREDICATE = Codec.BOOL.flatComapMap(bl -> bl != false ? Blocks::always : Blocks::never, p -> DataResult.error(() -> "Unsupported operation"));
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = new Codec<BlockPredicate>(){

        public <T> DataResult<Pair<BlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            String stringValue = ops.getStringValue(input).result().orElse(null);
            if (stringValue != null) {
                if (stringValue.startsWith("#")) {
                    return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.block().of(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)stringValue.substring(1)))).build(), (Object)ops.empty()));
                }
                return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.block().of(new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)stringValue))}).build(), (Object)ops.empty()));
            }
            return DataResult.error(() -> "Raw JSON input is not supported");
        }

        public <T> DataResult<T> encode(BlockPredicate input, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "Not supported yet");
        }
    };

    public static <T> Codec<T> simpleByNameCodec(Map<ResourceLocation, T> map) {
        return ResourceLocation.CODEC.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success(value);
        }, value -> DataResult.error(() -> "Unsupported operation"));
    }

    public static <T> Codec<T> simpleByNameCodec(BiMap<String, T> map) {
        return CustomizationCodecs.simpleByNameCodec(map, Codec.STRING);
    }

    public static <K, V> Codec<V> simpleByNameCodec(BiMap<K, V> map, Codec<K> keyCodec) {
        return keyCodec.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success((Object)value);
        }, value -> {
            Object key = map.inverse().get(value);
            if (key == null) {
                return DataResult.error(() -> "Unknown value: " + String.valueOf(value));
            }
            return DataResult.success((Object)key);
        });
    }

    public static <T> Codec<BlockBehaviour.StateArgumentPredicate<T>> stateArgumentPredicate() {
        return new Codec<BlockBehaviour.StateArgumentPredicate<T>>(){

            public <R> DataResult<R> encode(BlockBehaviour.StateArgumentPredicate<T> input, DynamicOps<R> ops, R prefix) {
                return DataResult.error(() -> "Unsupported operation");
            }

            public <R> DataResult<Pair<BlockBehaviour.StateArgumentPredicate<T>, R>> decode(DynamicOps<R> ops, R input) {
                String s;
                Optional booleanValue = ops.getBooleanValue(input).result();
                if (booleanValue.isPresent()) {
                    BlockBehaviour.StateArgumentPredicate predicate = (Boolean)booleanValue.get() != false ? CustomizationCodecs::always : CustomizationCodecs::never;
                    return DataResult.success((Object)Pair.of((Object)predicate, (Object)ops.empty()));
                }
                Optional stringValue = ops.getStringValue(input).result();
                if (stringValue.isPresent() && "ocelot_or_parrot".equals(s = (String)stringValue.get())) {
                    return DataResult.success((Object)Pair.of((state, world, pos, entity) -> entity == EntityType.OCELOT || entity == EntityType.PARROT, (Object)ops.empty()));
                }
                return DataResult.error(() -> "Failed to decode state argument predicate: " + String.valueOf(input));
            }
        };
    }

    public static <T> boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return true;
    }

    public static <T> boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return false;
    }

    static {
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"empty"), (Object)SoundType.EMPTY);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"wood"), (Object)SoundType.WOOD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"gravel"), (Object)SoundType.GRAVEL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"grass"), (Object)SoundType.GRASS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"lily_pad"), (Object)SoundType.LILY_PAD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"stone"), (Object)SoundType.STONE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"metal"), (Object)SoundType.METAL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"glass"), (Object)SoundType.GLASS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"wool"), (Object)SoundType.WOOL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sand"), (Object)SoundType.SAND);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"snow"), (Object)SoundType.SNOW);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"powder_snow"), (Object)SoundType.POWDER_SNOW);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"ladder"), (Object)SoundType.LADDER);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"anvil"), (Object)SoundType.ANVIL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"slime_block"), (Object)SoundType.SLIME_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"honey_block"), (Object)SoundType.HONEY_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"wet_grass"), (Object)SoundType.WET_GRASS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"coral_block"), (Object)SoundType.CORAL_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"bamboo"), (Object)SoundType.BAMBOO);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"bamboo_sapling"), (Object)SoundType.BAMBOO_SAPLING);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"scaffolding"), (Object)SoundType.SCAFFOLDING);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sweet_berry_bush"), (Object)SoundType.SWEET_BERRY_BUSH);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"crop"), (Object)SoundType.CROP);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"hard_crop"), (Object)SoundType.HARD_CROP);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"vine"), (Object)SoundType.VINE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_wart"), (Object)SoundType.NETHER_WART);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"lantern"), (Object)SoundType.LANTERN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"stem"), (Object)SoundType.STEM);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nylium"), (Object)SoundType.NYLIUM);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"fungus"), (Object)SoundType.FUNGUS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"roots"), (Object)SoundType.ROOTS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"shroomlight"), (Object)SoundType.SHROOMLIGHT);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"weeping_vines"), (Object)SoundType.WEEPING_VINES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"twisting_vines"), (Object)SoundType.TWISTING_VINES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"soul_sand"), (Object)SoundType.SOUL_SAND);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"soul_soil"), (Object)SoundType.SOUL_SOIL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"basalt"), (Object)SoundType.BASALT);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"wart_block"), (Object)SoundType.WART_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"netherrack"), (Object)SoundType.NETHERRACK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_bricks"), (Object)SoundType.NETHER_BRICKS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_sprouts"), (Object)SoundType.NETHER_SPROUTS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_ore"), (Object)SoundType.NETHER_ORE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"bone_block"), (Object)SoundType.BONE_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"netherite_block"), (Object)SoundType.NETHERITE_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"ancient_debris"), (Object)SoundType.ANCIENT_DEBRIS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"lodestone"), (Object)SoundType.LODESTONE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"chain"), (Object)SoundType.CHAIN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_gold_ore"), (Object)SoundType.NETHER_GOLD_ORE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"gilded_blackstone"), (Object)SoundType.GILDED_BLACKSTONE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"candle"), (Object)SoundType.CANDLE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"amethyst"), (Object)SoundType.AMETHYST);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"amethyst_cluster"), (Object)SoundType.AMETHYST_CLUSTER);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"small_amethyst_bud"), (Object)SoundType.SMALL_AMETHYST_BUD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"medium_amethyst_bud"), (Object)SoundType.MEDIUM_AMETHYST_BUD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"large_amethyst_bud"), (Object)SoundType.LARGE_AMETHYST_BUD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"tuff"), (Object)SoundType.TUFF);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"calcite"), (Object)SoundType.CALCITE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"dripstone_block"), (Object)SoundType.DRIPSTONE_BLOCK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"pointed_dripstone"), (Object)SoundType.POINTED_DRIPSTONE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"copper"), (Object)SoundType.COPPER);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"cave_vines"), (Object)SoundType.CAVE_VINES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"spore_blossom"), (Object)SoundType.SPORE_BLOSSOM);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"azalea"), (Object)SoundType.AZALEA);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"flowering_azalea"), (Object)SoundType.FLOWERING_AZALEA);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"moss_carpet"), (Object)SoundType.MOSS_CARPET);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"pink_petals"), (Object)SoundType.PINK_PETALS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"moss"), (Object)SoundType.MOSS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"big_dripleaf"), (Object)SoundType.BIG_DRIPLEAF);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"small_dripleaf"), (Object)SoundType.SMALL_DRIPLEAF);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"rooted_dirt"), (Object)SoundType.ROOTED_DIRT);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"hanging_roots"), (Object)SoundType.HANGING_ROOTS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"azalea_leaves"), (Object)SoundType.AZALEA_LEAVES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sculk_sensor"), (Object)SoundType.SCULK_SENSOR);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sculk_catalyst"), (Object)SoundType.SCULK_CATALYST);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sculk"), (Object)SoundType.SCULK);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sculk_vein"), (Object)SoundType.SCULK_VEIN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"sculk_shrieker"), (Object)SoundType.SCULK_SHRIEKER);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"glow_lichen"), (Object)SoundType.GLOW_LICHEN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"deepslate"), (Object)SoundType.DEEPSLATE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"deepslate_bricks"), (Object)SoundType.DEEPSLATE_BRICKS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"deepslate_tiles"), (Object)SoundType.DEEPSLATE_TILES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"polished_deepslate"), (Object)SoundType.POLISHED_DEEPSLATE);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"froglight"), (Object)SoundType.FROGLIGHT);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"frogspawn"), (Object)SoundType.FROGSPAWN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"mangrove_roots"), (Object)SoundType.MANGROVE_ROOTS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"muddy_mangrove_roots"), (Object)SoundType.MUDDY_MANGROVE_ROOTS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"mud"), (Object)SoundType.MUD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"mud_bricks"), (Object)SoundType.MUD_BRICKS);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"packed_mud"), (Object)SoundType.PACKED_MUD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"hanging_sign"), (Object)SoundType.HANGING_SIGN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_wood_hanging_sign"), (Object)SoundType.NETHER_WOOD_HANGING_SIGN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"bamboo_wood_hanging_sign"), (Object)SoundType.BAMBOO_WOOD_HANGING_SIGN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"bamboo_wood"), (Object)SoundType.BAMBOO_WOOD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"nether_wood"), (Object)SoundType.NETHER_WOOD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"cherry_wood"), (Object)SoundType.CHERRY_WOOD);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"cherry_sapling"), (Object)SoundType.CHERRY_SAPLING);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"cherry_leaves"), (Object)SoundType.CHERRY_LEAVES);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"cherry_wood_hanging_sign"), (Object)SoundType.CHERRY_WOOD_HANGING_SIGN);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"chiseled_bookshelf"), (Object)SoundType.CHISELED_BOOKSHELF);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"suspicious_sand"), (Object)SoundType.SUSPICIOUS_SAND);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"suspicious_gravel"), (Object)SoundType.SUSPICIOUS_GRAVEL);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"decorated_pot"), (Object)SoundType.DECORATED_POT);
        SOUND_TYPES.put((Object)ResourceLocation.withDefaultNamespace((String)"decorated_pot_cracked"), (Object)SoundType.DECORATED_POT_CRACKED);
        MAP_COLORS.put((Object)"none", (Object)MapColor.NONE);
        MAP_COLORS.put((Object)"grass", (Object)MapColor.GRASS);
        MAP_COLORS.put((Object)"sand", (Object)MapColor.SAND);
        MAP_COLORS.put((Object)"wool", (Object)MapColor.WOOL);
        MAP_COLORS.put((Object)"fire", (Object)MapColor.FIRE);
        MAP_COLORS.put((Object)"ice", (Object)MapColor.ICE);
        MAP_COLORS.put((Object)"metal", (Object)MapColor.METAL);
        MAP_COLORS.put((Object)"plant", (Object)MapColor.PLANT);
        MAP_COLORS.put((Object)"snow", (Object)MapColor.SNOW);
        MAP_COLORS.put((Object)"clay", (Object)MapColor.CLAY);
        MAP_COLORS.put((Object)"dirt", (Object)MapColor.DIRT);
        MAP_COLORS.put((Object)"stone", (Object)MapColor.STONE);
        MAP_COLORS.put((Object)"water", (Object)MapColor.WATER);
        MAP_COLORS.put((Object)"wood", (Object)MapColor.WOOD);
        MAP_COLORS.put((Object)"quartz", (Object)MapColor.QUARTZ);
        MAP_COLORS.put((Object)"color_orange", (Object)MapColor.COLOR_ORANGE);
        MAP_COLORS.put((Object)"color_magenta", (Object)MapColor.COLOR_MAGENTA);
        MAP_COLORS.put((Object)"color_light_blue", (Object)MapColor.COLOR_LIGHT_BLUE);
        MAP_COLORS.put((Object)"color_yellow", (Object)MapColor.COLOR_YELLOW);
        MAP_COLORS.put((Object)"color_light_green", (Object)MapColor.COLOR_LIGHT_GREEN);
        MAP_COLORS.put((Object)"color_pink", (Object)MapColor.COLOR_PINK);
        MAP_COLORS.put((Object)"color_gray", (Object)MapColor.COLOR_GRAY);
        MAP_COLORS.put((Object)"color_light_gray", (Object)MapColor.COLOR_LIGHT_GRAY);
        MAP_COLORS.put((Object)"color_cyan", (Object)MapColor.COLOR_CYAN);
        MAP_COLORS.put((Object)"color_purple", (Object)MapColor.COLOR_PURPLE);
        MAP_COLORS.put((Object)"color_blue", (Object)MapColor.COLOR_BLUE);
        MAP_COLORS.put((Object)"color_brown", (Object)MapColor.COLOR_BROWN);
        MAP_COLORS.put((Object)"color_green", (Object)MapColor.COLOR_GREEN);
        MAP_COLORS.put((Object)"color_red", (Object)MapColor.COLOR_RED);
        MAP_COLORS.put((Object)"color_black", (Object)MapColor.COLOR_BLACK);
        MAP_COLORS.put((Object)"gold", (Object)MapColor.GOLD);
        MAP_COLORS.put((Object)"diamond", (Object)MapColor.DIAMOND);
        MAP_COLORS.put((Object)"lapis", (Object)MapColor.LAPIS);
        MAP_COLORS.put((Object)"emerald", (Object)MapColor.EMERALD);
        MAP_COLORS.put((Object)"podzol", (Object)MapColor.PODZOL);
        MAP_COLORS.put((Object)"nether", (Object)MapColor.NETHER);
        MAP_COLORS.put((Object)"terracotta_white", (Object)MapColor.TERRACOTTA_WHITE);
        MAP_COLORS.put((Object)"terracotta_orange", (Object)MapColor.TERRACOTTA_ORANGE);
        MAP_COLORS.put((Object)"terracotta_magenta", (Object)MapColor.TERRACOTTA_MAGENTA);
        MAP_COLORS.put((Object)"terracotta_light_blue", (Object)MapColor.TERRACOTTA_LIGHT_BLUE);
        MAP_COLORS.put((Object)"terracotta_yellow", (Object)MapColor.TERRACOTTA_YELLOW);
        MAP_COLORS.put((Object)"terracotta_light_green", (Object)MapColor.TERRACOTTA_LIGHT_GREEN);
        MAP_COLORS.put((Object)"terracotta_pink", (Object)MapColor.TERRACOTTA_PINK);
        MAP_COLORS.put((Object)"terracotta_gray", (Object)MapColor.TERRACOTTA_GRAY);
        MAP_COLORS.put((Object)"terracotta_light_gray", (Object)MapColor.TERRACOTTA_LIGHT_GRAY);
        MAP_COLORS.put((Object)"terracotta_cyan", (Object)MapColor.TERRACOTTA_CYAN);
        MAP_COLORS.put((Object)"terracotta_purple", (Object)MapColor.TERRACOTTA_PURPLE);
        MAP_COLORS.put((Object)"terracotta_blue", (Object)MapColor.TERRACOTTA_BLUE);
        MAP_COLORS.put((Object)"terracotta_brown", (Object)MapColor.TERRACOTTA_BROWN);
        MAP_COLORS.put((Object)"terracotta_green", (Object)MapColor.TERRACOTTA_GREEN);
        MAP_COLORS.put((Object)"terracotta_red", (Object)MapColor.TERRACOTTA_RED);
        MAP_COLORS.put((Object)"terracotta_black", (Object)MapColor.TERRACOTTA_BLACK);
        MAP_COLORS.put((Object)"crimson_nylium", (Object)MapColor.CRIMSON_NYLIUM);
        MAP_COLORS.put((Object)"crimson_stem", (Object)MapColor.CRIMSON_STEM);
        MAP_COLORS.put((Object)"crimson_hyphae", (Object)MapColor.CRIMSON_HYPHAE);
        MAP_COLORS.put((Object)"warped_nylium", (Object)MapColor.WARPED_NYLIUM);
        MAP_COLORS.put((Object)"warped_stem", (Object)MapColor.WARPED_STEM);
        MAP_COLORS.put((Object)"warped_hyphae", (Object)MapColor.WARPED_HYPHAE);
        MAP_COLORS.put((Object)"warped_wart_block", (Object)MapColor.WARPED_WART_BLOCK);
        MAP_COLORS.put((Object)"deepslate", (Object)MapColor.DEEPSLATE);
        MAP_COLORS.put((Object)"raw_iron", (Object)MapColor.RAW_IRON);
        MAP_COLORS.put((Object)"glow_lichen", (Object)MapColor.GLOW_LICHEN);
        for (NoteBlockInstrument instrument : NoteBlockInstrument.values()) {
            if (!instrument.isTunable()) continue;
            INSTRUMENTS.put((Object)instrument.getSerializedName(), (Object)instrument);
        }
    }
}

