/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class MathUtil {
    private MathUtil() {
    }

    public static List<Vec3> fibonacciSphere(Vec3 start, double radius, int samples, boolean randomize) {
        double rnd = 1.0;
        if (randomize) {
            rnd = Math.random() * (double)samples;
        }
        double offset = 2.0 / (double)samples;
        double increment = Math.PI * (3.0 - Math.sqrt(5.0));
        ArrayList points = Lists.newArrayListWithCapacity((int)samples);
        for (int i = 0; i < samples; ++i) {
            double y = (double)i * offset - 1.0 + offset / 2.0;
            double r = Math.sqrt(1.0 - y * y) * radius;
            double phi = ((double)i + rnd) % (double)samples * increment;
            double x = Math.cos(phi) * r;
            double z = Math.sin(phi) * r;
            points.add(new Vec3(start.x + x, start.y + y * radius, start.z + z));
        }
        return points;
    }

    public static int posOnLine(Vec3 start, Vec3 end, Collection<BlockPos> list) {
        list.add(BlockPos.containing((Position)start));
        if (start.equals((Object)end)) {
            return 1;
        }
        int c = 1;
        double ex = Mth.lerp((double)-1.0E-7, (double)end.x, (double)start.x);
        double ey = Mth.lerp((double)-1.0E-7, (double)end.y, (double)start.y);
        double ez = Mth.lerp((double)-1.0E-7, (double)end.z, (double)start.z);
        double sx = Mth.lerp((double)-1.0E-7, (double)start.x, (double)end.x);
        double sy = Mth.lerp((double)-1.0E-7, (double)start.y, (double)end.y);
        double sz = Mth.lerp((double)-1.0E-7, (double)start.z, (double)end.z);
        int x = Mth.floor((double)sx);
        int y = Mth.floor((double)sy);
        int z = Mth.floor((double)sz);
        double subX = ex - sx;
        double subY = ey - sy;
        double subZ = ez - sz;
        int signX = Mth.sign((double)subX);
        int signY = Mth.sign((double)subY);
        int signZ = Mth.sign((double)subZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / subX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / subY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / subZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.frac((double)sx) : Mth.frac((double)sx));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.frac((double)sy) : Mth.frac((double)sy));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.frac((double)sz) : Mth.frac((double)sz));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    x += signX;
                    d12 += d9;
                } else {
                    z += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                y += signY;
                d13 += d10;
            } else {
                z += signZ;
                d14 += d11;
            }
            list.add(new BlockPos(x, y, z));
            ++c;
        }
        return c;
    }
}

