/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.gson.JsonElement;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.DumperOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.LoaderOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.Yaml;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.constructor.Constructor;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.error.YAMLException;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.Node;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.NodeId;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.SequenceNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.representer.Representer;

public final class KUtil {
    public static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,number,#.#}");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    private static final Yaml YAML;
    private static RecipeManager recipeManager;
    public static final List<Direction> DIRECTIONS;
    public static final List<Direction> HORIZONTAL_DIRECTIONS;

    private KUtil() {
    }

    public static String color(int color) {
        return String.format("\u00a7x%06x", color & 0xFFFFFF);
    }

    public static String formatComma(long number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static String formatCompact(long number) {
        int unit = 1000;
        if (number < (long)unit) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(unit));
        if (exp - 1 >= 0 && exp - 1 < 6) {
            char pre = "kMGTPE".charAt(exp - 1);
            return MESSAGE_FORMAT.format(new Double[]{(double)number / Math.pow(unit, exp)}) + pre;
        }
        return Long.toString(number);
    }

    public static String trimRL(ResourceLocation rl) {
        return KUtil.trimRL(rl, "minecraft");
    }

    public static String trimRL(String rl) {
        return KUtil.trimRL(rl, "minecraft");
    }

    public static String trimRL(ResourceLocation rl, String defaultNamespace) {
        return rl.getNamespace().equals(defaultNamespace) ? rl.getPath() : rl.toString();
    }

    public static String trimRL(String rl, String defaultNamespace) {
        if (rl.startsWith(defaultNamespace + ":")) {
            return rl.substring(defaultNamespace.length() + 1);
        }
        return rl;
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string) {
        try {
            return ResourceLocation.tryParse((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string, String defaultNamespace) {
        if (string != null && !((String)string).contains(":")) {
            string = defaultNamespace + ":" + (String)string;
        }
        return KUtil.RL((String)string);
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        ClientPacketListener connection;
        if (recipeManager == null && Platform.isPhysicalClient() && (connection = Minecraft.getInstance().getConnection()) != null) {
            return connection.getRecipeManager();
        }
        return recipeManager;
    }

    public static void setRecipeManager(RecipeManager recipeManager) {
        KUtil.recipeManager = recipeManager;
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipes(RecipeType<T> recipeTypeIn) {
        RecipeManager manager = KUtil.getRecipeManager();
        if (manager == null) {
            return List.of();
        }
        return KUtil.getRecipeManager().getAllRecipesFor(recipeTypeIn);
    }

    public static int friendlyCompare(String a, String b) {
        int aLength = a.length();
        int bLength = b.length();
        int minSize = Math.min(aLength, bLength);
        boolean asNumeric = false;
        int lastNumericCompare = 0;
        for (int i = 0; i < minSize; ++i) {
            boolean bNumber;
            char aChar = a.charAt(i);
            char bChar = b.charAt(i);
            boolean aNumber = aChar >= '0' && aChar <= '9';
            boolean bl = bNumber = bChar >= '0' && bChar <= '9';
            if (asNumeric) {
                if (aNumber && bNumber) {
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aNumber) {
                    return 1;
                }
                if (bNumber) {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    if (aChar != bChar) {
                        return aChar - bChar;
                    }
                    asNumeric = false;
                    continue;
                }
                return lastNumericCompare;
            }
            if (aNumber && bNumber) {
                asNumeric = true;
                if (lastNumericCompare != 0) continue;
                lastNumericCompare = aChar - bChar;
                continue;
            }
            if (aChar == bChar) continue;
            return aChar - bChar;
        }
        if (asNumeric) {
            if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                return 1;
            }
            if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                return -1;
            }
            if (lastNumericCompare == 0) {
                return aLength - bLength;
            }
            return lastNumericCompare;
        }
        return aLength - bLength;
    }

    public static String friendlyText(String s) {
        StringBuilder sb = new StringBuilder();
        MutableBoolean lastIsUpper = new MutableBoolean(true);
        MutableBoolean nextIsUpper = new MutableBoolean(true);
        s.codePoints().forEach(ch -> {
            if (ch == 95 || ch == 46) {
                sb.append(' ');
                nextIsUpper.setTrue();
                return;
            }
            if (Character.isUpperCase(ch) && lastIsUpper.isFalse()) {
                sb.append(' ');
            } else if (Character.isLowerCase(ch)) {
                if (nextIsUpper.isTrue()) {
                    ch = Character.toUpperCase(ch);
                } else if (lastIsUpper.isTrue() && sb.length() > 1 && Character.isUpperCase(sb.codePointAt(sb.length() - 2))) {
                    sb.insert(sb.length() - 1, ' ');
                }
            }
            lastIsUpper.setValue(Character.isUpperCase(ch));
            nextIsUpper.setFalse();
            sb.appendCodePoint(ch);
        });
        return sb.toString();
    }

    public static boolean canPlayerBreak(Player player, BlockState state, BlockPos pos) {
        if (!player.mayBuild() || !player.level().mayInteract(player, pos)) {
            return false;
        }
        return player.isCreative() || !(state.getDestroyProgress(player, (BlockGetter)player.level(), pos) <= 0.0f);
    }

    public static int applyAlpha(int color, float alpha) {
        int alphaChannel;
        int prevAlphaChannel = color >> 24 & 0xFF;
        if (prevAlphaChannel > 0) {
            alpha *= (float)prevAlphaChannel / 256.0f;
        }
        if ((alphaChannel = (int)(255.0f * Mth.clamp((float)alpha, (float)0.0f, (float)1.0f))) < 5) {
            return 0;
        }
        return color & 0xFFFFFF | alphaChannel << 24;
    }

    public static float getPickRange(Player player) {
        float attrib = 5.0f;
        return player.isCreative() ? attrib : attrib - 0.5f;
    }

    public static void displayClientMessage(@Nullable Player player, boolean client, String key, Object ... args) {
        if (player == null) {
            return;
        }
        if (client != player.level().isClientSide) {
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)key, (Object[])args));
    }

    public static void jsonList(JsonElement json, Consumer<JsonElement> collector) {
        if (json.isJsonArray()) {
            for (JsonElement e : json.getAsJsonArray()) {
                collector.accept(e);
            }
        } else {
            collector.accept(json);
        }
    }

    @Nullable
    public static String[] readNBTStrings(CompoundTag tag, String key, @Nullable String[] strings) {
        if (!tag.contains(key, 9)) {
            return null;
        }
        ListTag list = tag.getList(key, 8);
        if (list.isEmpty()) {
            return null;
        }
        if (strings == null || strings.length != list.size()) {
            strings = new String[list.size()];
        }
        for (int i = 0; i < strings.length; ++i) {
            String s;
            strings[i] = s = list.getString(i);
        }
        return strings;
    }

    public static void writeNBTStrings(CompoundTag tag, String key, @Nullable String[] strings) {
        if (strings == null || strings.length == 0) {
            return;
        }
        ListTag list = new ListTag();
        for (String s : strings) {
            list.add((Object)StringTag.valueOf((String)s));
        }
        tag.put(key, (Tag)list);
    }

    public static InteractionResult onAttackEntity(Player player, Level world, InteractionHand hand, Entity entity, @Nullable EntityHitResult hitResult) {
        ItemStack stack;
        ItemFrame frame;
        if (entity instanceof ItemFrame && !(frame = (ItemFrame)entity).getItem().isEmpty() && !frame.isNoGravity() && !frame.isInvulnerable() && (stack = player.getItemInHand(hand)).is(Items.END_PORTAL_FRAME)) {
            frame.setInvisible(!frame.isInvisible());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static <T> T loadYaml(String yaml, Class<? super T> type) {
        return YAML.loadAs(yaml, type);
    }

    public static <T> T loadYaml(Reader reader, Class<? super T> type) {
        return YAML.loadAs(reader, type);
    }

    public static void dumpYaml(Object object, Writer writer) {
        YAML.dump(object, writer);
    }

    static {
        DIRECTIONS = Direction.stream().toList();
        HORIZONTAL_DIRECTIONS = Direction.Plane.HORIZONTAL.stream().toList();
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YAML = new Yaml(new ResafeConstructor(new LoaderOptions()), new Representer(dumperOptions), dumperOptions);
    }

    public static class ResafeConstructor
    extends Constructor {
        public ResafeConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
            this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
            this.yamlClassConstructors.put(NodeId.mapping, new ConstructSafeMapping());
            this.yamlClassConstructors.put(NodeId.sequence, new ConstructSafeSequence());
        }

        private class ConstructSafeMapping
        extends Constructor.ConstructMapping {
            private ConstructSafeMapping() {
                super(ResafeConstructor.this);
            }

            @Override
            public Object construct(Node node) {
                MappingNode mnode = (MappingNode)node;
                if (node.isTwoStepsConstruction()) {
                    return ResafeConstructor.this.newMap(mnode);
                }
                return ResafeConstructor.this.constructMapping(mnode);
            }

            @Override
            public void construct2ndStep(Node node, Object object) {
                ResafeConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
            }
        }

        private class ConstructSafeSequence
        extends Constructor.ConstructSequence {
            private ConstructSafeSequence() {
                super(ResafeConstructor.this);
            }

            @Override
            public Object construct(Node node) {
                SequenceNode snode = (SequenceNode)node;
                if (Set.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        throw new YAMLException("Set cannot be recursive.");
                    }
                    return ResafeConstructor.this.constructSet(snode);
                }
                if (Collection.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        return ResafeConstructor.this.newList(snode);
                    }
                    return ResafeConstructor.this.constructSequence(snode);
                }
                if (node.isTwoStepsConstruction()) {
                    return ResafeConstructor.this.createArray(node.getType(), snode.getValue().size());
                }
                return ResafeConstructor.this.constructArray(snode);
            }
        }
    }
}

