/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Object lock = new Object();
    private Supplier<T> delegate;
    @Nullable
    private T value;
    @Nullable
    private T fallback;

    public CachedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    public CachedSupplier(Supplier<T> delegate, @Nullable T fallback) {
        this.delegate = delegate;
        this.fallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.value != null) {
            return this.value;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.value == null) {
                this.value = this.delegate.get();
                this.delegate = null;
            }
        }
        return this.value != null ? this.value : this.fallback;
    }
}

