/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.shadowed.com.ezylang.evalex.functions.basic;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.FunctionParameter;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.FunctionParameters;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.basic.AbstractMinMaxFunction;
import snownee.kiwi.shadowed.com.ezylang.evalex.parser.Token;

@FunctionParameters(value={@FunctionParameter(name="firstValue"), @FunctionParameter(name="additionalValues", isVarArg=true)})
public class AverageFunction
extends AbstractMinMaxFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        MathContext mathContext = expression.getConfiguration().getMathContext();
        BigDecimal sum = Arrays.stream(parameterValues).map(EvaluationValue::getNumberValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal count = BigDecimal.valueOf(parameterValues.length);
        BigDecimal average = sum.divide(count, mathContext);
        return expression.convertValue(average);
    }
}

