/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class Platform {
    private Platform() {
    }

    public static boolean isModLoaded(String id) {
        ModList modList = ModList.get();
        if (modList == null) {
            return LoadingModList.get().getModFileById(id) != null;
        }
        return modList.isLoaded(id);
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isProduction() {
        return FMLEnvironment.production;
    }

    public static boolean isDataGen() {
        return DatagenModLoader.isRunningDataGen();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    public static boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer;
    }

    public static Packet<ClientGamePacketListener> defaultAddEntityPacket(Entity entity, ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket(entity, serverEntity);
    }

    public static boolean isCurativeItem(MobEffectInstance effectInstance, ItemStack stack) {
        Set cures = effectInstance.getCures();
        if (cures.contains(EffectCures.MILK) && stack.is(Tags.Items.BUCKETS_MILK)) {
            return true;
        }
        return cures.contains(EffectCures.HONEY) && stack.is(Items.HONEY_BOTTLE);
    }

    public static boolean isShearsLeftClickable(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.SHEARS_DIG);
    }

    public static boolean isShearsRightClickable(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.SHEARS_HARVEST) || stack.canPerformAction(ItemAbilities.SHEARS_DISARM);
    }

    public static Fluid getFluidFromBucket(BucketItem item) {
        return item.content;
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.literal((String)MessageFormat.format(I18n.get((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.translatable((String)s, (Object[])objects);
        }
    }

    public static String getTagTranslationKey(TagKey<?> tagKey) {
        return Tags.getTagTranslationKey(tagKey);
    }

    public static int getVersionNumber(String id) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(id).orElseThrow();
        ArtifactVersion version = container.getModInfo().getVersion();
        List<Integer> versions = List.of(Integer.valueOf(version.getMajorVersion()), Integer.valueOf(version.getMinorVersion()), Integer.valueOf(version.getIncrementalVersion()));
        int result = 0;
        for (int i : versions) {
            int group = Math.min(i, 99);
            result = result * 100 + group;
        }
        return result;
    }

    public static Type getPlatform() {
        return Type.NeoForge;
    }

    public static Type getPlatformSeries() {
        return Type.NeoForge;
    }

    public static enum Type {
        Vanilla,
        Fabric,
        Quilt,
        Forge,
        NeoForge,
        Unknown;

    }
}

