/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.neoforged.fml.ModList;
import snownee.kiwi.build.KiwiMetadata;
import snownee.kiwi.build.KiwiMetadataParser;

public record KiwiMetadataLoader(String modId) implements Function<KiwiMetadataParser, KiwiMetadata>
{
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KiwiMetadata apply(KiwiMetadataParser parser) {
        String name = "/%s.kiwi.yaml".formatted(this.modId);
        Path p = ModList.get().getModFileById(this.modId).getFile().findResource(new String[]{name});
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            if (is == null) {
                KiwiMetadata kiwiMetadata2 = null;
                return kiwiMetadata2;
            }
            KiwiMetadata kiwiMetadata = parser.load(is);
            return kiwiMetadata;
        }
        catch (IOException e) {
            return null;
        }
    }
}

