/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.loader.Platform;

public class ModItem
extends Item {
    public ModItem(Item.Properties builder) {
        super(builder);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, tooltip, tooltipFlag);
        if (Platform.isPhysicalClient() && !KiwiClientConfig.globalTooltip) {
            ModItem.addTip(itemStack, tooltip, tooltipFlag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addTip(ItemStack stack, List<Component> tooltip, TooltipFlag flagIn) {
        boolean ctrl;
        if (tooltip.isEmpty()) {
            return;
        }
        boolean shift = Screen.hasShiftDown();
        String key = shift == (ctrl = Screen.hasControlDown()) ? stack.getDescriptionId() + ".tip" : (shift ? stack.getDescriptionId() + ".tip.shift" : stack.getDescriptionId() + ".tip.ctrl");
        boolean hasKey = I18n.exists((String)key);
        if (!hasKey && shift != ctrl) {
            return;
        }
        if (hasKey) {
            ArrayList lines = Lists.newArrayList((Object[])I18n.get((String)key, (Object[])new Object[0]).split("\n"));
            tooltip.addAll(lines.stream().map(Component::literal).peek(c -> c.withStyle(ChatFormatting.GRAY)).toList());
        }
        if (shift == ctrl) {
            boolean hasShiftKey = I18n.exists((String)(key + ".shift"));
            boolean hasCtrlKey = I18n.exists((String)(key + ".ctrl"));
            if (hasShiftKey && hasCtrlKey) {
                tooltip.add((Component)Component.translatable((String)"tip.kiwi.press_shift_or_ctrl"));
            } else if (hasShiftKey) {
                tooltip.add((Component)Component.translatable((String)"tip.kiwi.press_shift"));
            } else if (hasCtrlKey) {
                tooltip.add((Component)Component.translatable((String)"tip.kiwi.press_ctrl"));
            }
        }
    }
}

