/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;

public record ConfigureWallShape(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) implements ConfiguringShape
{
    public static Codec<ConfigureWallShape> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("post_width").forGetter(ConfigureWallShape::width), (App)Codec.FLOAT.fieldOf("side_width").forGetter(ConfigureWallShape::depth), (App)Codec.FLOAT.fieldOf("post_max_y").forGetter(ConfigureWallShape::wallPostHeight), (App)Codec.FLOAT.fieldOf("side_min_y").forGetter(ConfigureWallShape::wallMinY), (App)Codec.FLOAT.fieldOf("low_side_max_y").forGetter(ConfigureWallShape::wallLowHeight), (App)Codec.FLOAT.fieldOf("tall_side_max_y").forGetter(ConfigureWallShape::wallTallHeight)).apply((Applicative)instance, ConfigureWallShape::new));
    }

    @Override
    public void configure(Block block, BlockShapeType type) {
        if (!(block instanceof WallBlock)) {
            throw new IllegalArgumentException("Block %s is not a WallBlock".formatted(block));
        }
        WallBlock wallBlock = (WallBlock)block;
        Map shapes = wallBlock.makeShapes(this.width / 2.0f, this.depth / 2.0f, this.wallPostHeight, this.wallMinY, this.wallLowHeight, this.wallTallHeight);
        switch (type) {
            case MAIN: {
                wallBlock.shapeByIndex = shapes;
                break;
            }
            case COLLISION: {
                wallBlock.collisionShapeByIndex = shapes;
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

