/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.duck.KPlayer;
import snownee.kiwi.customization.network.SSyncPlaceCountPacket;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.placement.PlaceMatchResult;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.util.KUtil;

public class PlacementSystem {
    private static final Cache<BlockPlaceContext, PlaceMatchResult> RESULT_CONTEXT = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(100L, TimeUnit.MILLISECONDS).build();

    public static boolean isDebugEnabled(Player player) {
        return player != null && player.isCreative() && player.getOffhandItem().is(Items.CHAINMAIL_HELMET);
    }

    public static void removeDebugBlocks(Level level, BlockPos start) {
        BlockPos.MutableBlockPos pos = start.mutable();
        pos.move(Direction.UP, 2);
        while (PlacementSystem.isBlockToRemove(level.getBlockState((BlockPos)pos))) {
            level.setBlockAndUpdate((BlockPos)pos, Blocks.AIR.defaultBlockState());
            pos.move(Direction.UP);
        }
    }

    private static boolean isBlockToRemove(BlockState blockState) {
        if (blockState.is(Blocks.BEDROCK)) {
            return true;
        }
        String namespace = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).getNamespace();
        return CustomizationHooks.getBlockNamespaces().contains(namespace);
    }

    public static BlockState onPlace(BlockItem blockItem, BlockState blockState, BlockPlaceContext context) {
        PlaceMatchResult result;
        PlaceMatchResult result2;
        PlaceChoices choices = null;
        KBlockSettings settings = KBlockSettings.of(blockState.getBlock());
        if (settings != null) {
            choices = settings.placeChoices;
        }
        if (choices != null && !choices.alter().isEmpty()) {
            for (PlaceChoices.Alter alter : choices.alter()) {
                BlockState altered = alter.alter(blockItem, context);
                if (altered == null) continue;
                return PlacementSystem.onPlace(blockItem, altered, context);
            }
        }
        if (PlaceSlot.hasNoSlots(blockState.getBlock())) {
            return blockState;
        }
        if (context.isSecondaryUseActive() && (choices == null || choices.skippable())) {
            return blockState;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        Map<Direction, Collection<PlaceSlot>> neighborSlots = Direction.stream().map($ -> PlaceSlot.find(level.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, $)), $.getOpposite())).filter(Predicate.not(Collection::isEmpty)).collect(Collectors.toUnmodifiableMap($ -> ((PlaceSlot)$.iterator().next()).side().getOpposite(), Function.identity()));
        if (neighborSlots.isEmpty()) {
            return blockState;
        }
        boolean debug = PlacementSystem.isDebugEnabled(context.getPlayer());
        ArrayList results = Lists.newArrayList();
        boolean waterLoggable = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED);
        boolean hasWater = waterLoggable && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        BlockState noWaterBlockState = hasWater ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : blockState;
        PlaceMatchResult originalResult = null;
        for (BlockState possibleState : blockState.getBlock().getStateDefinition().getPossibleStates()) {
            if (waterLoggable && hasWater != (Boolean)possibleState.getValue((Property)BlockStateProperties.WATERLOGGED)) continue;
            int bonusInterest = 0;
            if (choices != null && (bonusInterest = choices.test(blockState, possibleState)) == Integer.MIN_VALUE || (result2 = PlacementSystem.getPlaceMatchResultAt(possibleState, neighborSlots, bonusInterest)) == null) continue;
            results.add(result2);
            if (possibleState != noWaterBlockState) continue;
            originalResult = result2;
        }
        if (results.isEmpty()) {
            if (debug && !level.isClientSide) {
                Kiwi.LOGGER.info("No match");
                level.setBlockAndUpdate((BlockPos)mutable.move(Direction.UP), Blocks.BEDROCK.defaultBlockState());
            }
            return blockState;
        }
        results.sort(null);
        int resultIndex = 0;
        int maxInterest = ((PlaceMatchResult)results.get(0)).interest();
        if (maxInterest > 0 && results.size() > 1 && (result2 = context.getPlayer()) instanceof KPlayer) {
            KPlayer player = (KPlayer)((Object)result2);
            int i = 1;
            while (i < results.size() && ((PlaceMatchResult)results.get(i)).interest() >= maxInterest) {
                resultIndex = i++;
            }
            if (resultIndex > 0) {
                resultIndex = player.kiwi$getPlaceCount() % (resultIndex + 1);
            }
        }
        PlaceMatchResult placeMatchResult = result = maxInterest == 0 ? originalResult : (PlaceMatchResult)results.get(resultIndex);
        if (result == null) {
            return blockState;
        }
        if (debug && maxInterest > 0 && !level.isClientSide) {
            mutable.setWithOffset((Vec3i)pos, Direction.UP);
            Kiwi.LOGGER.info("Interest: %d".formatted(result.interest()));
            results.forEach($ -> {
                if ($ == result) {
                    return;
                }
                level.setBlockAndUpdate((BlockPos)mutable.move(Direction.UP), $.blockState());
                Kiwi.LOGGER.info("Alt Interest: %d : %s".formatted($.interest(), $.blockState()));
            });
        }
        BlockState resultState = result.blockState();
        for (SlotLink.MatchResult link : result.links()) {
            resultState = link.onLinkFrom().apply(level, pos, resultState);
        }
        RESULT_CONTEXT.put((Object)context, (Object)result);
        return resultState;
    }

    @Nullable
    public static PlaceMatchResult getPlaceMatchResultAt(BlockState blockState, Map<Direction, Collection<PlaceSlot>> theirSlotsMap, int bonusInterest) {
        int interest = 0;
        ArrayList results = List.of();
        ArrayList offsets = List.of();
        for (Direction side : KUtil.DIRECTIONS) {
            Collection<PlaceSlot> ourSlots;
            SlotLink.MatchResult result;
            Collection<PlaceSlot> theirSlots = theirSlotsMap.get(side);
            if (theirSlots == null || (result = SlotLink.find(ourSlots = PlaceSlot.find(blockState, side), theirSlots)) == null) continue;
            SlotLink link = result.link();
            interest += link.interest();
            if (results.isEmpty()) {
                results = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
                offsets = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
            }
            results.add((SlotLink.MatchResult)result);
            offsets.add(side.getNormal());
        }
        if (interest < 0) {
            return null;
        }
        return new PlaceMatchResult(blockState, interest + bonusInterest, results, offsets);
    }

    public static void onBlockPlaced(BlockPlaceContext context) {
        PlaceMatchResult result = (PlaceMatchResult)RESULT_CONTEXT.getIfPresent((Object)context);
        if (result == null) {
            return;
        }
        RESULT_CONTEXT.invalidate((Object)context);
        BlockPos.MutableBlockPos mutable = context.getClickedPos().mutable();
        for (int i = 0; i < result.links().size(); ++i) {
            BlockPos.MutableBlockPos theirPos = mutable.setWithOffset((Vec3i)context.getClickedPos(), result.offsets().get(i));
            BlockState theirState = context.getLevel().getBlockState((BlockPos)theirPos);
            SlotLink.MatchResult link = result.links().get(i);
            theirState = link.onLinkTo().apply(context.getLevel(), (BlockPos)theirPos, theirState);
            context.getLevel().setBlock((BlockPos)theirPos, theirState, 11);
        }
        Player player = context.getPlayer();
        if (player != null) {
            ((KPlayer)player).kiwi$incrementPlaceCount();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SSyncPlaceCountPacket.sync(serverPlayer);
            }
        }
    }

    public static void onBlockRemoved(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (PlaceSlot.hasNoSlots(oldState.getBlock())) {
            return;
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (Direction direction : KUtil.DIRECTIONS) {
            SlotLink.MatchResult result;
            BlockState neighborState = level.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction));
            if (PlaceSlot.hasNoSlots(neighborState.getBlock()) || (result = SlotLink.find(oldState, neighborState, direction)) == null) continue;
            neighborState = result.onUnlinkTo().apply(level, (BlockPos)mutable, neighborState);
            level.setBlockAndUpdate((BlockPos)mutable, neighborState);
        }
    }
}

