/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket
public record CConvertItemPacket(boolean inContainer, boolean convertOne, int slot, Holder<Item> from, Entry entry) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CConvertItemPacket> TYPE = new CustomPacketPayload.Type(Kiwi.id("convert_item"));
    public static final int MAX_STEPS = 4;

    public CConvertItemPacket(boolean inContainer, int slot, Entry entry, Item from, boolean convertOne) {
        this(inContainer, convertOne, slot, (Holder<Item>)from.builtInRegistryHolder(), entry);
    }

    @NotNull
    public CustomPacketPayload.Type<CConvertItemPacket> type() {
        return TYPE;
    }

    public record Entry(float ratio, List<Pair<KHolder<BlockFamily>, Item>> steps) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Pair<KHolder<BlockFamily>, Item>> ENTRY_PAIR_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, p -> ((KHolder)p.getFirst()).key(), (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Pair::getSecond, (rl, item) -> Pair.of(new KHolder<Object>((ResourceLocation)rl, null), (Object)item));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Entry::ratio, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, ENTRY_PAIR_STREAM_CODEC), Entry::steps, Entry::new);

        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public Item item() {
            return (Item)this.steps.getLast().getSecond();
        }
    }

    public record Group(LinkedHashSet<Entry> entries) {
        public Group() {
            this(Sets.newLinkedHashSet());
        }
    }

    public static class Handler
    implements PlayPacketHandler<CConvertItemPacket> {
        public static final StreamCodec<RegistryFriendlyByteBuf, CConvertItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CConvertItemPacket::inContainer, (StreamCodec)ByteBufCodecs.BOOL, CConvertItemPacket::convertOne, (StreamCodec)ByteBufCodecs.VAR_INT, CConvertItemPacket::slot, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CConvertItemPacket::from, Entry.STREAM_CODEC, CConvertItemPacket::entry, CConvertItemPacket::new);

        @Override
        public void handle(CConvertItemPacket packet, PayloadContext context) {
            ServerPlayer player = context.serverPlayer();
            if (KiwiCommonConfig.kSwitchCreativeOnly && !player.isCreative()) {
                return;
            }
            boolean convertOne = packet.convertOne;
            boolean inContainer = packet.inContainer;
            int slotIndex = packet.slot;
            Item from = (Item)packet.from.value();
            List<Pair<KHolder<BlockFamily>, Item>> steps = packet.entry.steps;
            if (steps.isEmpty() || steps.size() > 4) {
                return;
            }
            Item to = (Item)steps.getLast().getSecond();
            if (from == to) {
                return;
            }
            context.execute(() -> {
                ItemStack newItem;
                ItemStack sourceItem;
                Item item = from;
                int index = 0;
                float ratio = 1.0f;
                for (Pair step : steps) {
                    BlockFamily family = BlockFamilies.get(((KHolder)step.getFirst()).key());
                    if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((Item)step.getSecond()))) {
                        return;
                    }
                    if (!family.switchAttrs().cascading() && index != steps.size() - 1) {
                        return;
                    }
                    if (!player.isCreative()) {
                        ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((Item)step.getSecond());
                    }
                    item = (Item)step.getSecond();
                    ++index;
                }
                Slot slot = null;
                Inventory playerInventory = player.getInventory();
                try {
                    if (slotIndex == -500) {
                        if (!player.isCreative()) return;
                        sourceItem = from.getDefaultInstance();
                    } else if (inContainer) {
                        slot = (Slot)player.containerMenu.slots.get(slotIndex);
                        if (!slot.allowModification((Player)player)) {
                            return;
                        }
                        sourceItem = slot.getItem();
                    } else {
                        sourceItem = playerInventory.getItem(slotIndex);
                    }
                }
                catch (Exception e) {
                    return;
                }
                if (!sourceItem.is(from)) {
                    return;
                }
                boolean skipSettingSlot = false;
                int inventorySwap = Integer.MIN_VALUE;
                if (ratio >= 1.0f) {
                    newItem = to.getDefaultInstance();
                } else {
                    if (convertOne) {
                        return;
                    }
                    for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                        ItemStack stack = playerInventory.getItem(i);
                        if (!stack.is(to)) continue;
                        inventorySwap = i;
                        break;
                    }
                    if (inventorySwap == Integer.MIN_VALUE) {
                        return;
                    }
                    newItem = playerInventory.getItem(inventorySwap);
                }
                newItem.setPopTime(5);
                int ratioInt = Mth.floor((float)ratio);
                if (convertOne) {
                    if (!player.isCreative()) {
                        sourceItem.shrink(1);
                        newItem.setCount(ratioInt);
                    }
                    if (!sourceItem.isEmpty()) {
                        this.addToPlayer(player, newItem, !inContainer);
                        skipSettingSlot = true;
                    }
                } else if (inventorySwap == Integer.MIN_VALUE) {
                    int maxSize = newItem.getMaxStackSize();
                    int count = Math.min(sourceItem.getCount(), maxSize / ratioInt);
                    newItem.setCount(count * ratioInt);
                    if (!player.isCreative()) {
                        sourceItem.shrink(count);
                    }
                }
                if (slotIndex != -500 && !skipSettingSlot) {
                    try {
                        if (inContainer) {
                            if (!slot.mayPlace(newItem)) {
                                return;
                            }
                            slot.setByPlayer(newItem);
                        } else {
                            playerInventory.setItem(slotIndex, newItem);
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                if (inventorySwap != Integer.MIN_VALUE) {
                    playerInventory.setItem(inventorySwap, sourceItem);
                } else if (!skipSettingSlot && !player.isCreative()) {
                    this.addToPlayer(player, sourceItem.copy(), !inContainer);
                }
                Handler.playPickupSound((Player)player);
                player.containerMenu.broadcastChanges();
            });
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, CConvertItemPacket> streamCodec() {
            return STREAM_CODEC;
        }

        private void addToPlayer(ServerPlayer player, ItemStack itemStack, boolean nextToSelected) {
            int slot;
            Inventory inventory = player.getInventory();
            IntStream intStream = IntStream.range(0, 9);
            if (nextToSelected) {
                IntStream leftAndRight = IntStream.of(inventory.selected + 1, inventory.selected - 1);
                intStream = IntStream.concat(leftAndRight, intStream);
            }
            if (!inventory.add(slot = intStream.filter(Inventory::isHotbarSlot).filter(i -> {
                ItemStack stack = inventory.getItem(i);
                if (stack.isEmpty()) {
                    return true;
                }
                return stack.getCount() < stack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack);
            }).findFirst().orElse(-1), itemStack) && !player.isCreative()) {
                player.drop(itemStack, true);
            }
        }

        public static void playPickupSound(Player player) {
            player.level().playSound((Player)(player.isLocalPlayer() ? player : null), player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }
}

