/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import snownee.kiwi.customization.item.loader.ItemCodecs;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.item.loader.KItemTemplates;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class BuiltInItemTemplate
extends KItemTemplate {
    public static final ThreadLocal<Item.Properties> PROPERTIES_INJECTOR = new ThreadLocal();
    private final Optional<ResourceLocation> key;
    private MapCodec<Item> codec;

    public BuiltInItemTemplate(Optional<ItemDefinitionProperties> properties, Optional<ResourceLocation> key) {
        super(properties);
        this.key = key;
    }

    public static MapCodec<BuiltInItemTemplate> directCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemDefinitionProperties.mapCodecField().forGetter(KItemTemplate::properties), (App)ResourceLocation.CODEC.optionalFieldOf("codec").forGetter(BuiltInItemTemplate::key)).apply((Applicative)instance, BuiltInItemTemplate::new));
    }

    @Override
    public KItemTemplate.Type<?> type() {
        return KItemTemplates.BUILT_IN.getOrCreate();
    }

    @Override
    public void resolve(ResourceLocation key, OneTimeLoader.Context context) {
        this.codec = ItemCodecs.get(this.key.orElse(key));
    }

    @Override
    public Item createItem(ResourceLocation id, Item.Properties properties, JsonObject json) {
        if (!json.has("properties")) {
            json.add("properties", (JsonElement)new JsonObject());
        }
        PROPERTIES_INJECTOR.set(properties);
        DataResult result = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap((JsonElement)json).result().orElseThrow());
        if (result.error().isPresent()) {
            throw new IllegalStateException(((DataResult.Error)result.error().get()).message());
        }
        return (Item)result.result().orElseThrow();
    }

    public Optional<ResourceLocation> key() {
        return this.key;
    }

    public String toString() {
        return "BuiltInItemTemplate[properties=" + String.valueOf(this.properties) + ", key=" + String.valueOf(this.key) + ", codec=" + String.valueOf(this.codec) + "]";
    }
}

