/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.customization.item.loader.ItemCodecs;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class MultipleBlockItem
extends BlockItem {
    public static final MapCodec<MultipleBlockItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.compoundList((Codec)Codec.STRING, (Codec)BuiltInRegistries.BLOCK.byNameCodec()).fieldOf("blocks").forGetter($ -> {
        throw new UnsupportedOperationException();
    }), ItemCodecs.propertiesCodec()).apply((Applicative)instance, MultipleBlockItem::new));
    private final List<Pair<String, Block>> blocks;

    public MultipleBlockItem(List<Pair<String, Block>> blocks, Item.Properties properties) {
        super((Block)blocks.get(0).getSecond(), properties);
        this.blocks = blocks;
        Preconditions.checkArgument((blocks.size() > 1 ? 1 : 0) != 0, (Object)"MultipleBlockItem must have more than one block");
        Preconditions.checkArgument((boolean)blocks.stream().map(Pair::getSecond).allMatch(block -> block != Blocks.AIR), (Object)"MultipleBlockItem cannot have AIR block");
    }

    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        this.blocks.stream().map(Pair::getSecond).forEach(block -> pBlockToItemMap.put((Block)block, pItem));
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        this.blocks.stream().map(Pair::getSecond).forEach(blockToItemMap::remove);
    }

    public Block getBlock(String name) {
        for (Pair<String, Block> pair : this.blocks) {
            if (!((String)pair.getFirst()).equals(name)) continue;
            return (Block)pair.getSecond();
        }
        return Blocks.AIR;
    }
}

